//
// filter.h -- common stream filter for Open Web Middleware 
//
//	Version 1.1
//
//      Copyright (C) 2006 Kazunari Saitoh
//
//      This library is free software; you can redistribute it and/or
//      modify it under the terms of the GNU Lesser General Public
//      License as published by the Free Software Foundation; either
//      version 2.1 of the License, or (at your option) any later version.
//
//      This library is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//      Lesser General Public License for more details.
//
//      You should have received a copy of the GNU Lesser General Public
//      License along with this library; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#ifndef __OMT_FILTER_H
#define __OMT_FILTER_H

#include <omt/gstream.h>

#ifndef NO_NAMESPACE
namespace omt {
#endif

// utility
// -----------------------------------------------------------------------------
inline int getocta( int a ) { return ( '0' <= a && a <= '7' ) ? a - '0' : -1; }
inline int gethexa( int a ) { return ( '0' <= a && a <= '9' ) ? a - '0' :
				     ( 'a' <= a && a <= 'f' ) ? a - 'a' + 10 : 
				     ( 'A' <= a && a <= 'F' ) ? a = 'A' + 10 : -1; }
inline int hexchar( int x ) { return (  0 <= x && x <=  9 ) ? '0' + x :
                                     ( 10 <= x && x <= 15 ) ? 'A' + x - 10 : -1; }
       
// Common filter
// -----------------------------------------------------------------------------
void copy_cstr( gistream& in, gostream& out, int trm = -1 );

void escape_cstr( gistream& in, gostream& out, int trm = -1 );
void unescape_cstr( gistream& in, gostream& out, int trm = -1 );

void encode64( gistream& in, gostream& out, int term = -1 );
void decode64( gistream& in, gostream& out, int term = -1 );

#ifndef NO_NAMESPACE
}
#endif

#endif

