﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.ComponentModel.Composition;
using System.Diagnostics;

namespace OGSNET.Plugins.GameOn
{
    using OGSNET.Plugin;

    /** \brief AVAの起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameOn.AVA")]
    public class AVA : GamePluginBase
    {
        /** \brief プラグインの情報を初期化する */
        public AVA()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "Alliance of Valiant Arms (GameOn) プラグイン ", "pine",
                    "Alliance of Valiant Arms (GameOn) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("ゲームオン", "GameOn", "Alliance of Valiant Arms",
                    "http://ava.gamechu.jp/");
        }

        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("GameOn", this.LoadTopPage);
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.StartCallback(CallbackStatus.Notice, "AVAのトップページを読み込んでいます。");
            this.Navigate("http://ava.gamechu.jp/", this.GameStart);
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.StartCallback(CallbackStatus.Notice, "ゲームを起動しています。");

            var flash  = this.Document.GetElementById("flash_gamestart_loginSWF");
            var elements = flash.GetElementsByTagName("param").Cast<HtmlElement>();

            // flashvars は複数有り
            var query =
                from A
                in elements
                where A.Name == "flashvars"
                select A.GetAttribute("value");

            // 起動に成功したかのフラグ
            var success = false;

            foreach (var value in query)
            {
                var regex = new Regex("GAMESTART_LOGIN_URL=(.+)(?:$|&)"); // javascript:～ の形で入ってる
                var match = regex.Match(value);

                if (match.Success && match.Groups.Count == 2)
                {
                    this.Navigate(match.Groups[1].Value);
                    success = true;
                    break;
                }
            }

            if (success)
            {
                this.StartCallback(CallbackStatus.Finish, "ゲームの起動に成功しました。");
            } else {
                this.StartCallback(CallbackStatus.Error, "ゲーム開始に必要なパラメーターが見つかりません。");
            }
        }
    }
}
