﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.ComponentModel.Composition;
using System.Windows.Forms;

namespace OGSNET.Plugins.Plaync
{
    using OGSNET.Plugin;

    /** plaync のゲームのベースクラス */
    public class PlayncBase : GamePluginBase
    {
        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("Plaync", this.LoadTopPage);
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("ゲームのトップページを読み込んでいます。");
            this.Navigate(this.GameStartUrl, this.GameStart);
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.Notice("ゲームを開始しています。");

            // 関数を実行
            this.Document.InvokeScript("eval", new object[] { this.GameStartScript });
        }

        /** \brief ゲーム開始時に実行するスクリプト */
        protected string GameStartScript
        {
            get;
            set;
        }

        /** \brief ゲームの開始ページのURL */
        private string GameStartUrl_ = null;
        protected string GameStartUrl
        {
            get { return GameStartUrl_ ?? this.GameInfo.Url.AbsoluteUri; }
            set { this.GameStartUrl_ = value; }
        }
    }

    /** \brief The Tower of AION の起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Plaync.AION")]
    public class AION : PlayncBase
    {
        public AION()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "The Tower of AION (plaync) 起動プラグイン", "pine",
                    "The Tower of AION (plaync) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("plaync", "Plaync", "The Tower of AION", "http://aion.plaync.jp/");

            this.GameStartScript = "FlashStartButton(\"27\")";
        }
    }

    /** \brief リネージュの起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Plaync.Lineage")]
    public class Lineage : PlayncBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Lineage()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "リネージュ (plaync) 起動プラグイン", "pine",
                    "リネージュ (plaync) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("plaync", "Plaync", "リネージュ", "http://lineage.plaync.jp/");

            this.GameStartScript = "launcherStart()";
        }
    }

    /** \biref 雀龍門の起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Plaync.Janryumon")]
    public class Janryumon : PlayncBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Janryumon()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "雀龍門 (plaync) 起動プラグイン", "pine",
                    "雀龍門 (plaync) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("plaync", "Plaync", "雀龍門", "http://janryumon.plaync.jp/");

            this.GameStartScript = "launcherStart()";
        }
    }

    /** \brief ドリフトシティ・ブースト */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Plaync.Driftcity")]
    public class Driftcity : PlayncBase
    {
        /** \brief プラグインの基本情報の初期化処理 */
        public Driftcity()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ドリフトシティ・ブースト (plaync) 起動プラグイン", "pine",
                    "ドリフトシティ・ブースト (plaync) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("plaync", "Plaync", "ドリフトシティ・ブースト", "http://driftcity.plaync.jp/Main.aspx");

            this.GameStartUrl = "http://driftcity.arario.jp/goPage.action?pageName=goMainPower&carName=puma&refer=null&cpd=arario&s=2";
            this.GameStartScript = "startGame()";
        }
    }
}
