﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;
using System.Windows.Forms;

/** \brief エムゲームの名前空間 */
namespace OGSNET.Plugins.Mgame
{
    using OGSNET.Plugin;

    /** \brief エムゲームの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "Mgame")]
    public class Operation : OperationPluginBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "エムゲーム 運営プラグイン", "pine",
                    "エムゲームが運営しているゲームを起動するために使われるプラグインです。");

            this.OperationInfo =
                new OperationInfo("エムゲーム", "http://www.mgame.jp/");
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            this.LogoutAndLoadLoginPage();
        }

        /** \brief ログアウトし、ログインページを表示する */
        private void LogoutAndLoadLoginPage()
        {
            this.Notice("エムゲームのログインページにアクセスしています。");
            this.Navigate("http://www.mgame.jp/logout.html", this.Login);
        }

        /** \brief ログインをする */
        private void Login()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("エムゲームにログインしています。");

            // フォームを取得
            var forms = this.Document.All.GetElementsByName("login_form");

            // 入力エレメントを取得
            var user = this.Document.GetElementById("userid");
            var pass = this.Document.GetElementById("password");

            if (user == null || pass == null || forms.Count == 0)
            {
                this.Error("エムゲームへのログインに失敗しました。");
                return;
            }

            // 値を設定
            user.SetAttribute("value", this.UserName);
            pass.SetAttribute("value", this.Password);

            // 送信
            this.AddAction("http://www.mgame.jp/login_error.html", this.LoginError);
            this.AddAction("http://www.mgame.jp/", this.EndLogin);

            // フォームのチェック関数を呼ぶ
            if ((bool)this.Document.InvokeScript("goLogin"))
            {
                forms[0].InvokeMember("submit");
            }
            else
            {
                this.Error("エムゲームへのログインに失敗しました。");
            }
        }

        /** \brief ログインエラー */
        private void LoginError()
        {
            this.Error("エムゲームへのログインに失敗しました。ユーザー名もしくはパスワードが間違っています。");
        }

        /** \brief ログイン成功 */
        private void EndLogin()
        {
            this.EndPlugin("エムゲームへのログインに成功しました。");
        }
    }
}