﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Windows.Forms;

/** \brief ゲームヤロウの名前空間 */
namespace OGSNET.Plugins.GameYarou
{
    using OGSNET.Plugin;

    /** \brief ゲームヤロウの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "GameYarou")]
    public class Operation : OperationPluginBase
    {
        /** \brief プラグインの初期化処理 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ゲームヤロウ 運営プラグイン", "pine",
                    "ゲームヤロウのゲームを起動する際に利用されるプラグインです。");

            this.OperationInfo =
                new OperationInfo("ゲームヤロウ", "http://www.gameyarou.jp/");
        }

        /** \brief プラグインを起動する */
        protected override void StartPlugin()
        {
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("ゲームヤロウのトップページを読み込んでいます。");
            this.Navigate("http://www.gameyarou.jp/index.asp", this.LoginOrLogout);
        }

        /** \brief ログインとログアウトの処理 */
        private void LoginOrLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("トップページのロードに成功しました。");

            // ログインフォームを取得
            var form = this.Document.GetElementById("LoginLeftForm");

            // ログイン済み
            if (form == null)
            {
                // ログアウトの処理
                this.Notice("ゲームヤロウからログアウトしています。");
                this.Navigate("https://secure.gameyarou.jp/Member/Login/__Common_Logout_Proc.asp?r_dmn=http://www.gameyarou.jp/?d_url=http%3A%2F%2Fwww%2Egameyarou%2Ejp%2Findex%2Easp",
                    this.EndLogout, "http://www.gameyarou.jp/");

            }

            // 未ログイン
            else
            {
                this.Notice("ゲームヤロウへログインしています。");

                // ユーザーIDとパスワードのフォームを取得
                var user = this.Document.GetElementById("ID_user_id");
                var pass = this.Document.GetElementById("ID_user_pwd");

                if (user == null || pass == null)
                {
                    this.Error("ゲームヤロウへのログインに失敗しました。");
                    return;
                }

                // 値を設定
                user.SetAttribute("value", this.UserName);
                pass.SetAttribute("value", this.Password);

                // 送信
                this.AddAction(new Regex(@"^http://www.gameyarou.jp/\?d_url="), this.EndLogin);
                this.Document.InvokeScript("eval", new object [] { "RBLoginControl.ValidateLoginForm()" });
            }
        }

        /** \brief ログイン後の処理 */
        private void EndLogin()
        {
            this.EndPlugin("ゲームヤロウへのログインに成功しました。");
        }

        /** \brief ログアウト後の処理 */
        private void EndLogout()
        {
            this.ClearAction();
            this.Notice("ゲームヤロウからログアウトしました。");
            this.LoginOrLogout();
        }
    }
}
