/* ndeview.c */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <libgen.h>

#include "video.h"
#include "audio.h"
#include "ifile.h"
#include "ofile.h"
#include "parseopt.h"
#include "term_util.h"
#include "util.h"
#include "xwin.h"

//unsigned long version = VERSION(0,0,19,0);
const char *prog_name = NULL;
//const char *defaults_file_name = NULL;
#define DEFAULTS_FILE_NAME "~/.ntvrec/ndeview"

int
show_help(void)
{
//  unsigned char *ver = (unsigned char*) &version;
  unsigned char *ver = VERSION;
  printf("\n"
         "%s version %s Copyright (c) 2002 tajio\n"
         "\n"
	 "usage: %s [OUTPUT FILE OPTIONS] <[INPUT FILE OPTIONS] <input_file>> [[INPUT FILE OPTIONS] <input_file> ...]\n"
	 , prog_name, ver, prog_name);
  parseopt_print_cmd_opt();
  exit(0);
}

OptionDef main_opt[] = {
    { "h", NULL, 0, {(void*)show_help}, {0}, {0}, 0, "show help", NULL },
//    { "defsfile", NULL, HAS_ARG|OPT_STR|OPT_BEFORE, {(void*)&defaults_file_name}, {(int)"~/.ntvrec/ndeview"}, {0}, 0, "defaults file name" },
};

int main_opt_num = sizeof(main_opt) / sizeof(OptionDef);

OptionDefs options[] = {
  {main_opt,    &main_opt_num,      NULL},
  {in_file_param, &in_file_param_num, "INPUT FILE OPTIONS"},
  {out_file_param, &out_file_param_num, "OUTPUT FILE OPTIONS"},
//  {audio_param, &audio_param_num,  "AUDIO OPTIONS"},
//  {xvid_param,  &xvid_param_num,   "XVID OPTIONS"},
  {NULL, NULL, NULL}
};

void
prog_quit(void)
{
  term_quit();
  quit_iofile();
  parseopt_quit();
}

int
main (int argc, char *argv[])
{
  int out_frame_count;
  int in_file_num = 0;
  int in_file_count = 0;
  int out_frame_num = 0;
  int ch, xch;
  int frm_num;
  int frm_count;
  int frame_rate;
  double out_fps;
  int v_bytes;
  int v_data_size;
  int a_bytes;
  int a_data_size;
  int av_bytes;
  int i_frm_count;
  int i_frm_num;
  int frm_start;
  double frame_time;
#define DIR_DECREMENT 0
#define DIR_INCREMENT 1
  int dir = 1;
  const char *in_filename = NULL;

  prog_name = basename(argv[0]);

  parseopt_set_default_func (set_in_filename);
  parseopt_set_option_defs (options);

//  parseopt_print_rc_opt();
//  exit(0);

  parseopt_defaults(DEFAULTS_FILE_NAME);
  parseopt_cmd(argc, argv);

  init_iofile();
  video_init();
//  audio_init();

  in_file_num = get_in_file_num();

  printf ("\n");
  printf ("Press 'k' to forward 1 frame\n");
  printf ("Press 'j' to backward 1 frame\n");
  printf ("Press 'l' to forward next key frame\n");
  printf ("Press 'h' to backward previous key frame\n");
  printf ("Press ';' to forward 1 minute\n");
  printf ("Press 'g' to backward 1 minute\n");
  printf ("Press 'm' to forward 3 second\n");
  printf ("Press 'n' to backward 3 second\n");
  printf ("Press 'q' to quit\n");
  printf ("\n");

  term_init();
  atexit(prog_quit);

  out_fps = video_get_out_fps();
  frame_rate = out_fps;
  frame_time = 1.0 / out_fps;

  out_frame_num = video_get_total_out_frames();

  out_frame_count = 0;
  v_bytes = a_bytes = 0;
  v_data_size = a_data_size = 0;
  av_bytes = 0;

//  for (in_file_count = 0; in_file_count < in_file_num; in_file_count++) {
  in_file_count = 0;
  ch = 0;
  frm_start = 0;
  frm_count = 0;
  dir = DIR_INCREMENT;
  while (ch != 'q' && ch != 'Q') {
    video_set_in_file(in_file_count);
    in_filename = video_get_in_filename();
    frm_num = video_get_frames_num();
    i_frm_num = video_get_in_frames();
    i_frm_count = 0;
//    audio_set_in_file(in_file_count);
//    for (frm_count = 0; frm_count < frm_num; frm_count++, out_frame_count++) {
    if (dir == DIR_DECREMENT) {
      frm_start -= frm_num;
      frm_count = frm_num + frm_count;
    }
    v_data_size = video_frame_process(frm_count);
    printf("frm_start %d, frm_count %d\n", frm_start, frm_count);
    while (ch != 'q' && ch != 'Q') {
      int pos;
      xch = x_dispatch_event ();
      ch = read_key();
      if (ch == -1)
	ch = xch;
      if (ch == 'q' || ch == 'Q') {
        break;
      }
      switch (ch) {
	case 'k':
	  frm_count++;
	  break;
	case 'j':
	  frm_count--;
	  break;
	case 'l':
	  pos = video_get_next_key_pos(frm_count);
	  frm_count = pos;
	  break;
	case 'm':
	  frm_count += (int)out_fps * 3;
	  break;
	case 'h':
	  pos = video_get_prev_key_pos(frm_count);
	  frm_count = pos;
	  break;
	case 'n':
	  frm_count -= (int)out_fps * 3;
	  break;
	case ';':
	  frm_count += (int)out_fps * 60;
	  break;
	case 'g':
	  frm_count -= (int)out_fps * 60;
	  break;
	default:
	  usleep(100);
	  continue;
      }

      if (frm_count >= frm_num) {
	if ((in_file_count+1) < in_file_num) {
	  frm_count = frm_count - frm_num;
	  frm_start += frm_num;
	  dir = DIR_INCREMENT;
	  break;
	} else {
	  frm_count = frm_num-1;
	  //continue;
	}
      } else if (frm_count < 0) {
	if (in_file_count <= 0) {
	  frm_count = 0;
	  //continue;
	} else {
	  dir = DIR_DECREMENT;
	  break;
	}
      }

      v_data_size = video_frame_process(frm_count);
      if (v_data_size < 0) {
	fprintf(stderr, "main: video_frame_process return %d\n", v_data_size);
	break;
      }
      v_bytes += v_data_size;

      i_frm_count = video_get_in_pos();
//      a_data_size = audio_frame_process(frm_count);
//      if (v_data_size < 0) {
//	fprintf(stderr, "main: video_frame_process return %d\n", v_data_size);
//	break;
//      }
//      a_bytes += a_data_size;

      av_bytes = v_bytes + a_bytes;

      printf("frames=% 7d/%d:% 7d/%d:%s\r",
	    (frm_count + frm_start + 1), out_frame_num,
	    (i_frm_count + 1), i_frm_num,
	    in_filename);
      fflush (stdout);
    }
//    audio_unset_in_file(in_file_count);
    video_unset_in_file(in_file_count);
//    if (out_frame_num <= out_frame_count)
    if (dir == DIR_INCREMENT)
      in_file_count++;
    else
      in_file_count--;
    if (ch == 'q' || ch == 'Q')
      break;
  }

//  audio_flush();

//  audio_quit();
  video_quit();
  quit_iofile();

#if 0
  printf("frames=% 8d/%d:% 3d%% size=%8ukB bitrate=%6.1fkbits/s\n",
	 out_frame_count, out_frame_num, out_frame_count*100/out_frame_num,
	 (av_bytes) / 1024,
	 (av_bytes) * 8.0 / (out_frame_count * frame_time) / 1000.0);
#endif

  printf("\nquit\n");

  exit(0);
}

