/*
 * mp3_frame.h (C) nejik 2003
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * References:
 * lame-3.93.1
 * lame-3.93.1/mpglib/common.c
 * lame-3.93.1/mpglib/interface.c
 * http://www.mp3dev.org
 */


#ifndef MP3_FRAME_H_INCLUDED
#define MP3_FRAME_H_INCLUDED

#ifndef FALSE
#define         FALSE                   0
#endif
#ifndef TRUE
#define         TRUE                    1
#endif

typedef struct MP3_FRAME_t {
  unsigned long head;
  int version;
#define MP3_VER_1  1
#define MP3_VER_2  2
#define MP3_VER_25 25
  int lsf;
  int layer;
#define MP3_LAY_1  1
#define MP3_LAY_2  2
#define MP3_LAY_3  3
  int protection;
  int bitrate;
  int frequency;
  int padding;
  int private_bit;
  int mode;
#define MP3_MODE_STEREO 0
#define MP3_MODE_JOINT  1
#define MP3_MODE_DUAL   2
#define MP3_MODE_MONO   3
  int mode_ext;
  int copyright;
  int original;
  int emphasis;

  int frame_length;
  int frame_samples;
  int stereo;
} MP3_FRAME;

int mp3_frame_header (MP3_FRAME *frame, unsigned char *stream, int stream_size, int *start);
int mp3_frame_header_vbr (MP3_FRAME *frame, unsigned char *stream, int stream_size, int *start);

#if 0
void print_mp3_frame_header (MP3_FRAME *fr);
#endif

#endif /* MP3_FRAME_H_INCLUDED */

