/* stts.h */

#ifndef STTS_H
#define STTS_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"

#define QTIME_TYPE_STTS    QTIME_TYPE('s','t','t','s')

typedef struct {
  uint32_t  sample_count;
  uint32_t  sample_duration;
} time_to_sample_t;

#define TIME_TO_SAMPLE_T_SIZE 8

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
} STTS_PROP;

#define STTS_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  int32_t  table_max;
  time_to_sample_t *table;

  uint32_t max_count;
  uint32_t max_duration;

  int32_t  idx;
  uint32_t st_count;
  uint32_t st_duration;
  uint32_t ed_count;
  uint32_t ed_duration;
} stts_t;


void    stts_init(stts_t *stts);
void    stts_clean(stts_t *stts);
stts_t* stts_new(void);
void    stts_delete(stts_t *stts);


stts_t* stts_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stts_t *stts);
stts_t* stts_create(stts_t *stts);
int     stts_write_atom(qtime_io_t *qtio, stts_t *stts);
int64_t stts_calc_size(stts_t *stts);
void    stts_dump(const char *parent_types, stts_t *stts);
int     stts_valid(stts_t *stts);


int32_t stts_move_init(stts_t *stts);
uint32_t stts_move_count(stts_t *stts, uint32_t count);
uint32_t stts_move_duration(stts_t *stts, uint32_t duration);


int32_t  stts_set_constant_duration(stts_t *stts,
                              uint32_t sample_count, uint32_t sample_duration);


uint32_t stts_get_count(stts_t *stts, uint32_t duration);
uint32_t stts_get_duration(stts_t *stts, uint32_t count);
uint32_t stts_get_sample_duration(stts_t *stts, uint32_t count);

uint32_t stts_add_sample_duration(stts_t *stts, uint32_t sample_count, uint32_t sample_duration);

uint32_t stts_get_max_count(stts_t *stts);
uint32_t stts_get_max_duration(stts_t *stts);

int      stts_get_sample_info(stts_t *stts, qtime_sample_info_t *spinfo);
int      stts_add_sample_info(stts_t *stts, qtime_sample_info_t *spinfo);


#endif /* STTS_H */

