/* qtime_track.h */

#ifndef QTIME_TRACK_H
#define QTIME_TRACK_H

#include "qtime_io.h"
#include "atom.h"
#include "qtime_track.h"
#include "qtime_media.h"
#include "qtime_sample.h"
#include "trak.h"
#include "tkhd.h"
#include "udta.h"
#include "mdia.h"
#include "edts.h"
#include "tref.h"
#include "load.h"
//#include "clip.h"
//#include "imap.h"
//#include "matt.h"


#define QTIME_TYPE_QTRK    QTIME_TYPE('Q','T','R','K')

typedef struct {
  trak_t   *trak;
  tkhd_t   *tkhd;
  edts_t   *edts;
  
  qtime_media_t qtmd;
  qtime_sample_t *qtsp;

  qtime_io_t *qtio;
  uint32_t media_type;

  uint32_t sample_count;
  uint32_t sample_duration;
  uint32_t sample_description_id;
  uint8_t  compressor[5];
} qtime_track_t;


void    qtime_track_init(qtime_track_t *qtime_track);
void    qtime_track_clean(qtime_track_t *qtime_track);
qtime_track_t* qtime_track_new(void);
void    qtime_track_delete(qtime_track_t *qtime_track);

qtime_track_t* qtime_track_create(qtime_track_t* qtrk, trak_t *trak);


int      qtime_track_set_moov_io(qtime_track_t *qtrk, qtime_io_t *mvio);
int      qtime_track_get_id(qtime_track_t *qtrk);
int      qtime_track_set_id(qtime_track_t *qtrk, int id);
int      qtime_track_set_movie_duration(qtime_track_t *qtrk, uint32_t duration);
uint32_t qtime_track_get_media_time_scale(qtime_track_t *qtrk);
int      qtime_track_set_media_time_scale(qtime_track_t *qtrk, uint32_t time_scale);
uint32_t qtime_track_get_media_duration(qtime_track_t *qtrk);

uint32_t qtime_track_get_media_type(qtime_track_t *qtrk);
int      qtime_track_set_media_type(qtime_track_t *qtrk, uint32_t media_type);
char*    qtime_track_get_compressor(qtime_track_t *qtrk);

uint32_t qtime_track_get_video_position(qtime_track_t *qtrk);
uint32_t qtime_track_set_video_position(qtime_track_t *qtrk, uint32_t position);
uint32_t qtime_track_get_video_frames(qtime_track_t *qtrk);
int      qtime_track_get_video_width(qtime_track_t *qtrk);
int      qtime_track_get_video_height(qtime_track_t *qtrk);
double   qtime_track_get_video_fps(qtime_track_t *qtrk);
int      qtime_track_video_is_keyframe(qtime_track_t *qtrk, uint32_t count);
uint32_t qtime_track_video_next_keyframe(qtime_track_t *qtrk, uint32_t count);
uint32_t qtime_track_video_prev_keyframe(qtime_track_t *qtrk, uint32_t count);
int      qtime_track_read_video(qtime_track_t *qtrk, uint8_t *buf, int *keyframe);
int      qtime_track_write_video(qtime_track_t *qtrk, uint8_t *buf, int size, int keyframe);

int      qtime_track_set_video_fps(qtime_track_t *qtrk, double fps);
int      qtime_track_set_video(qtime_track_t *qtrk, int width, int height, double fps, uint8_t *compressor);



int      qtime_track_get_audio_rate(qtime_track_t *qtrk);
int      qtime_track_get_audio_bits(qtime_track_t *qtrk);
int      qtime_track_get_audio_channels(qtime_track_t *qtrk);
int      qtime_track_set_audio(qtime_track_t *qtrk,
                        int channels, int rate, int bits, uint8_t *compressor);
int      qtime_track_read_audio(qtime_track_t *qtrk, uint8_t *buf, int *num_samples);
int      qtime_track_write_audio(qtime_track_t *qtrk,
                        uint8_t *data, int data_size, int number_of_samples);

int      qtime_track_get_audio_ext(qtime_track_t *qtrk,
                        int8_t *version, int16_t *compression_id,
		       	uint32_t *samples_per_packet,uint32_t *bytes_per_packet,
		       	uint32_t *bytes_per_frame, uint32_t *bytes_per_sample);
int      qtime_track_set_audio_ext(qtime_track_t *qtrk,
                        int8_t version, int16_t compression_id,
		       	uint32_t samples_per_packet, uint32_t bytes_per_packet,
		       	uint32_t bytes_per_frame, uint32_t bytes_per_sample);
uint32_t qtime_track_get_audio_samples(qtime_track_t *qtrk);
uint32_t qtime_track_get_audio_position(qtime_track_t *qtrk);
uint32_t qtime_track_set_audio_position(qtime_track_t *qtrk, uint32_t position);



#endif /* QTIME_TRACK_H */

