/* ifile.h */

#ifndef __IFILE_HDR
#define __IFILE_HDR

#include <avilib.h>
#include <qtime.h>
#include "parseopt.h"

#define MAX_FILENAME_LENGTH 4096

#define MAX_IN_FILE_NUM     64

typedef struct {
    int start;
      int end;
} CUT_BLOCK;

typedef struct {
  char *name;

#define FILE_FORMAT_UNKNOWN 0
#define FILE_FORMAT_AVI     1
#define FILE_FORMAT_MOV     2
  int file_format;
  avi_t *avifile;

  qtime_t *qt;
  qtime_track_t *vqtrk;
  qtime_track_t *aqtrk;

  int actual_frames;
  int frames;
  int vcodec;
  int actual_width;
  int actual_height;
  int width;
  int height;
  int crop_left;
  int crop_right;
  int crop_top;
  int crop_bottom;
  double fps;
  const char *compressor;

  int cut_blocks_num;
  CUT_BLOCK *cut_blocks;

  int read_frames;
  int field_order;
//  int frame_shift;

  int acodec;
  int channels;
  int bits;
  int format;
  int sfmt;
  int rate;
  long audio_bytes;
  int bitrate;
  int bytespspl;
  int audio_be;
  int audio_samples;
  int audio_frames;
  int audio_frame_samples;

  int video_decode_flag;

  int interlaced_src_flag;
  int deinterlace_flag;
  int deinterlace_type;
//  int deinterlace_y_only_flag;
//  int deinterlace_uv_only_flag;
  int median_filt_flag;
  int mid4_filt_flag;
  int flicker_func;
  int flicker_level;
  int flicker_eval_per;

  int yuvdenoise_flag;
  int denoise_flag;
  int denoise_radius;
  int denoise_threshold;
  int denoise_ppthreshold;
  int denoise_delay;
  int denoise_sharpen;
  int denoise_uv_flag;
  int denoise_uvthreshold;
  const char *denoise_test;

  int bright;
  int hue;
  int contrast;
  int color;

  int refer_count;
} IN_FILE;

int init_ifile(void);
void quit_ifile(void);
int get_in_file_num(void);
IN_FILE* set_in_file_video(int index);
IN_FILE* set_in_file_audio(int index);
void unset_in_file_video(int index);
void unset_in_file_audio(int index);
int set_in_file_video_frame_position(IN_FILE* i_file, int position);
int read_video_data(IN_FILE* i_file, unsigned char *read_buf, int *keyframe);
int prev_key_frame(IN_FILE* in_file, int pos);
int next_key_frame(IN_FILE* in_file, int pos);
int set_in_filename(const char *name);
//int set_audio_position(IN_FILE *i_file, int pos);
int set_audio_position_start(IN_FILE *i_file);
int read_audio_data(IN_FILE *i_file, unsigned char *buf, int *num_samples);
int check_in_files(void);
int ifile_calc_total_frames(double out_fps);
IN_FILE *ifile_get_in_file(int index);
int ifile_calc_total_audio_bytes(void);

extern OptionDef in_file_param[];
extern int in_file_param_num;

#endif /* __IFILE_HDR */

