/* vmhd.h */

#ifndef VMHD_H
#define VMHD_H

#include "qtime_io.h"
#include "atom.h"
#include "vmhd.h"

#define QTIME_TYPE_VMHD    QTIME_TYPE('v','m','h','d')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint16_t graphics_mode;
  uint16_t opcolor[3];
} VMHD_PROP;

#define VMHD_PROP_SIZE (12)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  uint16_t graphics_mode;
  uint16_t opcolor[3];
} vmhd_t;


void    vmhd_init(vmhd_t *vmhd);
void    vmhd_clean(vmhd_t *vmhd);
vmhd_t* vmhd_new(void);
void    vmhd_delete(vmhd_t *vmhd);

int64_t vmhd_calc_size(vmhd_t *vmhd);
vmhd_t* vmhd_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, vmhd_t *vmhd);
vmhd_t* vmhd_create(vmhd_t* vmhd);
int     vmhd_write_atom(qtime_io_t *qtio, vmhd_t *vmhd);
void    vmhd_dump(const char *parent_types, vmhd_t *vmhd);


#endif /* VMHD_H */

