/* tref.h */

#ifndef TREF_H
#define TREF_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_TREF    QTIME_TYPE('t','r','e','f')

#define QTIME_TYPE_TMCD    QTIME_TYPE('t','m','c','d') 
#define QTIME_TYPE_CHAP    QTIME_TYPE('c','h','a','p') 
#define QTIME_TYPE_SYNC    QTIME_TYPE('s','y','n','c') 
#define QTIME_TYPE_SCPT    QTIME_TYPE('s','c','p','t') 
#define QTIME_TYPE_SSRC    QTIME_TYPE('s','s','r','c') 
#define QTIME_TYPE_HINT    QTIME_TYPE('h','i','n','t') 

typedef struct {
  uint32_t  size;
  uint32_t  type;
  int       track_id_num;
  int32_t*  track_id;
} tref_type_t;

typedef struct {
  atom_t atom;

  int tref_type_num;
  tref_type_t **tref_type;
} tref_t;


void    tref_init(tref_t *tref);
tref_t* tref_new(void);
void    tref_clean(tref_t *tref);
void    tref_delete(tref_t *tref);
tref_t* tref_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, tref_t *tref);
tref_t* tref_create(tref_t *tref);
int64_t tref_calc_size(tref_t *tref);
int     tref_write_atom(qtime_io_t *qtio, tref_t *tref);
void    tref_dump(const char *parent_types, tref_t *tref);


#endif /* TREF_H */

