/* qtime_sample_info.h */

#ifndef QTIME_SAMPLE_INFO_H
#define QTIME_SAMPLE_INFO_H

#include "sample_desc.h"


#define QTIME_SAMPLE_INFO_FLAG_KEYFRAME      (1L<<0)
#define QTIME_SAMPLE_INFO_FLAG_OVER_MAX      (1L<<1)

typedef struct {
  uint32_t count;
  uint32_t duration;
  uint32_t flag;

  uint32_t samples;
  uint32_t sample_size;
  uint32_t sample_duration;

  int32_t  chunk;
  uint32_t chunk_start_count;
  uint32_t samples_per_chunk;
  int32_t  sample_description_id;
  uint32_t chunk_samples;
  int32_t  last_chunk;
  int32_t  last_sample_description_id;

  sample_desc_t *sample_desc;
  uint32_t media_type;
  uint32_t bytes_per_sample;

  uint32_t last_count;
  int64_t  last_data_offset;

  int64_t  data_start_offset;
  int64_t  data_end_offset;
} qtime_sample_info_t;


void qtime_sample_info_init(qtime_sample_info_t *spinfo);


#endif /* QTIME_SAMPLE_INFO_H */

