/* mdat.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "qtime_io.h"
#include "qtime_util.h"
#include "qtime_error.h"
#include "atom.h"
#include "mdat.h"

void
mdat_init(mdat_t *mdat)
{
  atom_init(&mdat->atom);
  mdat->atom.type = QTIME_TYPE_MDAT;
  mdat->ext_size = 0;

  mdat->start_offset = 0;
  mdat->end_offset = 0;
//  mdat->data_start_offset = 0;
//  mdat->cur_offset = 0;
}

void
mdat_clean(mdat_t *mdat)
{
  mdat_init(mdat);
}

mdat_t*
mdat_create(void)
{
  mdat_t *mdat;
  mdat = (mdat_t*)qtime_malloc(sizeof(mdat_t));
  if (!mdat) return NULL;
  mdat_init(mdat);
  return mdat;
}

void
mdat_delete(mdat_t *mdat)
{
  if (mdat)
    qtime_free(mdat);
}

int
mdat_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, mdat_t *mdat)
{
#ifndef NDEBUG
  qtime_io_t *io;
  io = qtio;
  qtime_error_type_check_v(QTIME_TYPE_MDAT, atom_head->type, QTIME_ERROR_ILLEGAL_ATOM)
#endif

  mdat->atom.size = 1;
  mdat->atom.type = QTIME_TYPE_MDAT;
  mdat->ext_size = atom_head->size;
  mdat->atom.flag = atom_head->flag;
  mdat->atom.parent = atom_head->parent;
  mdat->start_offset = atom_head->start_offset;
  mdat->end_offset = atom_head->end_offset;
//  mdat->data_start_offset = atom_head->start_offset + (atom_head->size - atom_head->body_size);
  return QTIME_OK;
}

void
mdat_dump(mdat_t *mdat)
{
  uint8_t type_str[5];
  qtime_type_to_str(mdat->atom.type, type_str);
  fprintf(stdout, "%s: size         %lld\n", type_str, (int64_t)mdat->atom.size);
  fprintf(stdout, "%s: ext_size     %lld\n", type_str, (int64_t)mdat->ext_size);
  fprintf(stdout, "%s: start_offset %lld\n", type_str, mdat->start_offset);
  fprintf(stdout, "%s: end_offset   %lld\n", type_str, mdat->end_offset);
}

int64_t
mdat_calc_size(mdat_t *mdat)
{
  int64_t size;
  size = mdat->end_offset - mdat->start_offset;
  mdat->ext_size = size;
  return size;
}

int
mdat_write_init(qtime_io_t *qtio, mdat_t *mdat)
{
  uint32_t ui32;
  int64_t  i64;
  mdat->start_offset = qtime_io_get_offset(qtio);
  ui32 = 1;
  qtime_io_write32(qtio, &ui32);
  ui32 = QTIME_TYPE_MDAT;
  qtime_io_write_type(qtio, &ui32);
  i64 = 8 + 8;
  qtime_io_write64(qtio, &i64);
//  mdat->cur_offset = mdat->data_start_offset = qtime_io_get_offset(qtio);

  return QTIME_OK;
}

int
mdat_write_end(qtime_io_t *qtio, mdat_t *mdat)
{
  uint32_t ui32;
  int64_t  i64;

  mdat->end_offset = qtime_io_get_offset(qtio);
  qtime_io_set_offset(qtio, mdat->start_offset);
  ui32 = 1;
  qtime_io_write32(qtio, &ui32);
  ui32 = QTIME_TYPE_MDAT;
  qtime_io_write_type(qtio, &ui32);
  i64 = mdat->end_offset - mdat->start_offset;
  qtime_io_write64(qtio, &i64);
  qtime_io_set_offset(qtio, mdat->end_offset);

  return QTIME_OK;
}

int
mdat_write_finish(qtime_io_t *qtio, mdat_t *mdat)
{
  uint32_t ui32;
  int64_t  i64, offset;

  offset = qtime_io_get_offset(qtio);
  qtime_io_set_offset(qtio, mdat->start_offset);
  ui32 = 1;
  qtime_io_write32(qtio, &ui32);
  ui32 = QTIME_TYPE_MDAT;
  qtime_io_write_type(qtio, &ui32);
  i64 = mdat->end_offset - mdat->start_offset;
  qtime_io_write64(qtio, &i64);
  qtime_io_set_offset(qtio, offset);

  return QTIME_OK;
}

int
mdat_set_start_offset(mdat_t *mdat, int64_t start_offset)
{
  if (start_offset < 0)
    return QTIME_ERROR;
  mdat->start_offset = start_offset;
  return QTIME_OK;
}

int
mdat_set_end_offset(mdat_t *mdat, int64_t end_offset)
{
  if (end_offset < mdat->start_offset+16)
    return QTIME_ERROR;
  mdat->end_offset = end_offset;
  return QTIME_OK;
}

int64_t
mdat_get_start_offset(mdat_t *mdat)
{
  return mdat->start_offset;
}

int64_t
mdat_get_end_offset(mdat_t *mdat)
{
  return mdat->end_offset;
}

