/* matt.h */

#ifndef MATT_H
#define MATT_H

#include "qtime_io.h"
#include "atom.h"
#include "kmat.h"

#define QTIME_TYPE_MATT    QTIME_TYPE('m','a','t','t')

typedef struct {
  atom_t   atom;
  kmat_t   *kmat;
} matt_t;


void    matt_init(matt_t *matt);
void    matt_clean(matt_t *matt);
matt_t* matt_create(void);
void    matt_delete(matt_t *matt);


int64_t matt_calc_size(matt_t *matt);
int     matt_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, matt_t *matt);
matt_t* matt_create_read_atom(qtime_io_t *qtio, atom_head_t *atom_head);
int     matt_write_atom(qtime_io_t *qtio, matt_t *matt);
void    matt_dump(const char *parent_types, matt_t *matt);


#endif /* MATT_H */

