/* load.h */

#ifndef LOAD_H
#define LOAD_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_LOAD    QTIME_TYPE('l','o','a','d')

#define FLAG_LOAD_ALWAYS_ENABLE 1
#define FLAG_LOAD_ENABLE        2

#define LOAD_HINT_DOUBLE_BUFFER      0x0020
#define LOAD_HINT_HIGH_QUALITY       0x0020

typedef struct {
  uint32_t  preload_start_time;
  uint32_t  preload_duration;
  uint32_t  preload_flags;
  uint32_t  default_hints;
} LOAD_PROP;

#define LOAD_PROP_SIZE (16)

typedef struct {
  atom_t    atom;
  uint32_t  preload_start_time;
  uint32_t  preload_duration;
  uint32_t  preload_flags;
  uint32_t  default_hints;
} load_t;


void    load_init(load_t *load);
void    load_clean(load_t *load);
load_t* load_new(void);
void    load_delete(load_t *load);

int64_t load_calc_size(load_t *load);
load_t* load_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, load_t *load);
load_t* load_create(load_t *load);
int     load_write_atom(qtime_io_t *qtio, load_t *load);
void    load_dump(const char *parent_types, load_t *load);


#endif /* LOAD_H */

