/* atom.h */

#ifndef ATOM_H
#define ATOM_H

#include <inttypes.h>

#include "qtime_io.h"

#define QTIME_TYPE(a,b,c,d) (((a)<<24)|((b)<<16)|((c)<<8)|(d))

#define QTIME_TYPE_UNKNOWN   QTIME_TYPE(0,0,0,0)

#define QTIME_TYPE_FREE      QTIME_TYPE('f','r','e','e')
#define QTIME_TYPE_WIDE      QTIME_TYPE('w','i','d','e')

#define SIZE64MASK    0x7fffffff00000000LL

#if 0
typedef struct {
  uint8_t reserved[10];    // must be set to 0.
  uint8_t lock_count[16];  // must be set to 0.
} QTATOM_CONTAINER_HEAD;

typedef struct {
  int32_t size;
  int32_t type;         // if root atom, set to "sean"
  int32_t atom_id;      // if root atom, value of 1.
  int16_t reserved;     // must be set to 0.
  int16_t child_count;  // if 0, atom is leaf atom.
  int32_t reserved32;   // must be set to 0.
} QTATOM_HEAD;
#endif

typedef struct ATOM_T atom_t;
typedef atom_t** atom_list_t;
typedef uint32_t atom_size_t;
#define ATOM_SIZE_T_LENGTH 4
#if ATOM_SIZE_T_LENGTH == 4
#define ATOM_SIZE_MAX  (4294967295U)
#endif

struct ATOM_T {
  atom_size_t size;
  uint32_t    type;
  uint32_t    flag;
  int32_t     index;
  int32_t     number_of_childs;
  atom_list_t childs;
  atom_t*     parent;
};

typedef struct {
  int64_t     size;
  uint32_t    type;

  uint32_t    media_type;

  int64_t     body_size;
  int64_t     start_offset;
  int64_t     end_offset;

  atom_t*     parent;
  uint32_t    flag;
  int32_t     error_code;
} atom_head_t;


void atom_init(atom_t *atom);
void atom_clean(atom_t *atom);
void atom_head_init(atom_head_t *atom_head);


int atom_read_header(qtime_io_t *qtio, atom_head_t *atom_head);
int atom_read_footer(qtime_io_t *qtio, atom_head_t *atom_head);
int atom_write_header(qtime_io_t *qtio, atom_head_t *atom_head);
int atom_write_footer(qtime_io_t *qtio, atom_head_t *atom_head);


int  atom_add_child(atom_t *parent, atom_t *child);
int  atom_insert_child(atom_t *parent, atom_t *child, int idx);
int  atom_remove_child(atom_t *parent, atom_t *child);
int  atom_remove_child_all(atom_t *parent);


#define ATOM_FIND_CHILDS_ONLY   0
#define ATOM_FIND_RECURSIVE     1
atom_t*     atom_get_child(atom_t *atom, int idx);
atom_t*     atom_find(atom_t *atom, uint32_t type, int flag);
atom_t*     atom_find_child(atom_t *atom, uint32_t type);
atom_t*     atom_find_recursive(atom_t *atom, uint32_t type);
atom_list_t atom_find_atoms(atom_t *atom, uint32_t type, uint32_t flag,
                            int *num_atoms_ret);
atom_list_t atom_find_child_atoms(atom_t *atom, uint32_t type,
                            int *num_atoms_ret);
atom_list_t atom_find_recursive_atoms(atom_t *atom, uint32_t type,
                            int *num_atoms_ret);
void        atom_list_free(atom_list_t atom_list);
int         atom_count_child(atom_t *atom, uint32_t type);
int         atom_count_recursive(atom_t *atom, uint32_t type);



#endif /* ATOM_H */

