/* csp.c */

#include <inttypes.h>

#include "csp.h"

typedef struct {
  int csp_id;
  const char *csp_str;
  int pixel_depth;
  int equivalent;
} CSP_RES;

static CSP_RES csp_res[] = {
  { CSP_UNKNOWN, "CSP_UNKNOWN",  0 , CSP_UNKNOWN },
//  { CSP_GREY,    "CSP_GREY",     1, CSP_UNKNOWN  },
//  { CSP_HI240,   "CSP_HI240",    2, CSP_UNKNOWN  },
  { CSP_RGB32,   "CSP_RGB32",   32, CSP_UNKNOWN  },
  { CSP_RGB24,   "CSP_RGB24",   24, CSP_UNKNOWN  },
  { CSP_RGB565,  "CSP_RGB565",  16, CSP_UNKNOWN  },
  { CSP_RGB555,  "CSP_RGB555",  15, CSP_UNKNOWN  },

  { CSP_YUV422P, "CSP_YUV422P", 16, CSP_UNKNOWN  },

  { CSP_YUV422,  "CSP_YUV422",  16, CSP_YUV422   },
  { CSP_YUYV,    "CSP_YUYV",    16, CSP_YUV422   },
  { CSP_YUY2,    "CSP_YUY2",    16, CSP_YUV422   },

  { CSP_YVYU,    "CSP_YVYU",    16, CSP_UNKNOWN  },

  { CSP_UYVY,    "CSP_UYVY",    16, CSP_UNKNOWN  },

  { CSP_YUV420,  "CSP_YUV420",  12, CSP_UNKNOWN  },
  { CSP_YUV411,  "CSP_YUV411",  12, CSP_UNKNOWN  },

  { CSP_YUV411P, "CSP_YUV411P", 12, CSP_UNKNOWN  },

  { CSP_YUV420P, "CSP_YUV420P", 12, CSP_YUV420P  },
  { CSP_I420,    "CSP_I420",    12, CSP_YUV420P  },
  { CSP_IYUV,    "CSP_IYUV",    12, CSP_YUV420P  },

  { CSP_YV12,    "CSP_YV12",    12, CSP_UNKNOWN  },

  { CSP_YV12_INTERLACE,     "CSP_YV12_INTERLACE",     12, CSP_UNKNOWN  },
#ifdef HAVE_LIBXVIDCORE
  { CSP_XVID,               "CSP_XVID",               -1, CSP_UNKNOWN  },
#endif /* HAVE_LIBXVIDCORE */
#ifdef HAVE_RTJPEG
  { CSP_RTJPEG,             "CSP_RTJPEG",             -1, CSP_UNKNOWN  },
#endif /* HAVE_RTJPEG */
};

static int csp_res_num = sizeof(csp_res) / sizeof(CSP_RES);

int
csp_to_pixel_depth(int csp)
{
  int i;
  CSP_RES *res = csp_res;

  for (i = csp_res_num; i > 0; i--, res++) {
    if (res->csp_id == csp)
      return res->pixel_depth;
  }
  return 0;
}

const char *
csp_to_str(int csp)
{
  int i;
  CSP_RES *res = csp_res;

  for (i = csp_res_num; i > 0; i--, res++) {
    if (res->csp_id == csp)
      return res->csp_str;
  }
  return csp_res[0].csp_str;
}

