/* ac_mp3lame.h */

#ifndef _MP3LAME_H
#define _MP3LAME_H

#ifdef MMX
#undef MMX
#endif

#ifdef HAVE_LAME_H
#include <lame.h>
#endif

#ifdef HAVE_LAME_LAME_H
#include <lame/lame.h>
#endif

#include "acodec.h"
#include "mp3_frame.h"

typedef struct {
  int bitrate;
  int quality;
  int mode;
  int vbr_mode;
  int vbr_quality;

  int rate;
  int channels;
  int bits;
  int frame_size;

  lame_global_flags *gfp;
  uint8_t *stream_buf;
  int stream_buf_pos;
  int stream_buf_size;
  int frame_length;
  int frame_samples;
  int flushed;
  MP3_FRAME mp3frame;
  int analyzed;
} MP3LAME_CONFIG;

extern ACODEC_FUNCS mp3lame_funcs;

#endif /* _MP3LAME_H */

