/* Copyright 2013,2014 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _SEARCH_2CH_H_
#define _SEARCH_2CH_H_


typedef struct tag_nt_searched_thread_handle *nt_searched_thread_handle;
typedef struct tag_nt_searched_thread_handle{
	int chk_sum;
}nt_searched_thread_handle_t;

extern nt_searched_thread_handle nt_searched_thread_alloc(
		const wchar_t *board_name,const wchar_t *dat_name,
		const wchar_t *title);
extern nt_searched_thread_handle nt_searched_thread_alloc2(
		nt_2ch_model_handle h_model, 
		const char *url);
extern int nt_searched_thread_add_ref(nt_searched_thread_handle h_searched_thread);
extern int nt_searched_thread_release_ref(nt_searched_thread_handle h_searched_thread);

extern const wchar_t* nt_searched_thread_get_board_name(
			nt_searched_thread_handle handle);
extern const wchar_t* nt_searched_thread_get_dat_name(
			nt_searched_thread_handle handle);
extern const wchar_t* nt_searched_thread_get_title(
			nt_searched_thread_handle handle);

extern BOOL nt_get_search_text(const char *in_text, char** out_text);
extern nt_link_tp nt_search_all_board(nt_2ch_model_handle h_model, 
			const char *search_text, const wchar_t **error_msg);


#endif /* _SEARCH_2CH_H_ */
