/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/

#ifndef _NT_CLOUD_H_
#define _NT_CLOUD_H_

#ifdef NT_CLOUD

#define NT_CLOUD_TEST_SERVER ("https://neetchan.securesite.jp/test.php")

typedef struct tag_nt_cloud_handle *nt_cloud_handle;
typedef struct tag_nt_cloud_handle{
	int chk_sum;
}nt_cloud_handle_t;

extern nt_cloud_handle nt_cloud_init(
		const char *auth_url, const char *usr_id, const char *pass);
extern BOOL nt_cloud_chk_user(nt_cloud_handle handle);
extern BOOL nt_cloud_upload_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern nt_link_tp nt_cloud_download_file(nt_cloud_handle handle,
		const char *file_name);

extern BOOL nt_cloud_insert_lines_into_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern BOOL nt_cloud_delete_lines_from_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);

extern int nt_cloud_add_ref(nt_cloud_handle);
extern int nt_cloud_release_ref(nt_cloud_handle);

#endif /*NT_CLOUD*/
#endif /*_NT_CLOUD_H_*/
