<?php
/*
 nce (ntch cloud environment.)
 name: nc_update_readcnt_db.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-21th
 description:
 License: GPLv3
 */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$hashed_passwd = $_POST['hashed_passwd'];
$board_name = $_POST['board_name'];
$aes_enable = $_POST['aes_enable'];

//--- authorization ---
$user = chk_passwd( $user_id, $hashed_passwd);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

//--- parameter check start ---
if(!chk_param($board_name)){
	echo ERROR303;
	exit;
}

if(isset($aes_enable) && $aes_enable==1){
	$extra_filter = "record_type > 3 and record_type < 7";
}else{
	$extra_filter = "record_type > 0 and record_type < 4";
}
//--- parameter check end ---

$table_name = TABLE_PREFIX."tbl{$user->home_dir}";
$query1 = <<< QUERY1
select res_number, record_type, dat_name, last_update from $table_name 
    where board_name='{$board_name}' and {$extra_filter}
QUERY1;

try{
	$db->open();
	//echo $query1."\n";
	$result = $db->execute($query1);
	
	if(!$result){
		echo ERROR503;
		exit;
	}
	$db->close();
}catch(Exception $e){
	$error = __FILE__."(".__LINE__.
		") An error occured during query.";
	nc_logging($error, $e);
	echo ERROR500;
	exit;
}

echo SUCCESS100;
//echo $query1."\n";
//print_r($result);
for($i = 0; $i < $result->num_rows; $i++){
	$row = $result->fetch_assoc();
	echo $row['dat_name'].",".$row['res_number'].",".$row['record_type'].",".$row['last_update']."\n";
}

?>
