#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <openssl/sha.h>

#include "env.h"
#include "utils/nt_std_t.h"
#include "utils/db.h"

const char *nt_db_get_log_path()
{
	static char path[256];
	static int f = 0;
	if(f == 0){
		strcpy(path, LOG_PATH);
		strcat(path, "/");
		strcat(path, LOG_DB_NAME);
	}
	return path;
}

const char *nt_db_get_idx_path()
{
	static char path[256];
	static int f = 0;
	if(f == 0){
		strcpy(path, LOG_PATH);
		strcat(path, "/");
		strcat(path, INDEX_DB_NAME);
	}
	return path;
}


BOOL nt_db_cpy_key(const char *src, char *dst)
{
	assert(src != NULL);

	int len, offset;

	len = strlen(src);

	if(len < (DB_KEY_SIZE_MAX-1))
		return FALSE;

	offset = len - (DB_KEY_SIZE_MAX-1);
	memcpy(dst, src+offset, (DB_KEY_SIZE_MAX-1));
	dst[(DB_KEY_SIZE_MAX-1)] = '\0';

	return TRUE;
}
