#ifndef _MODEL_2CH_H_
#define _MODEL_2CH_H_

#include "utils/nt_std_t.h"

typedef struct tag_nt_category_t *nt_category_tp;
typedef struct tag_nt_category_t{
	wchar_t *name;
	nt_link_tp boardlistp;
} nt_category_t;


typedef struct tag_nt_board_t *nt_board_tp;
typedef struct tag_nt_board_t{
	wchar_t *name;
	wchar_t *address;
	nt_link_tp threadlistp;
} nt_board_t;

typedef struct tag_nt_thread_t *nt_thread_tp;
typedef struct tag_nt_thread_t{
	wchar_t *name;
	wchar_t *file_name;
	int num_res;
	nt_link_tp reslistp;
} nt_thread_t;

typedef struct tag_nt_res_t *nt_res_tp;
typedef struct tag_nt_res_t{
	int seq_no;
	wchar_t *name;
	wchar_t *mail;
	wchar_t *misc;
	wchar_t *msg;
	int msg_line_num;
	nt_link_tp msg_line_linkp;
} nt_res_t;

typedef struct tag_nt_2ch_model_t *nt_2ch_model_tp;
typedef struct tag_nt_2ch_model_t{
	nt_link_tp categorylistp;

	nt_category_tp selected_categoryp;
	nt_board_tp selected_boardp;
	nt_thread_tp selected_threadp;

} nt_2ch_model_t;

typedef struct tag_nt_write_data_t *nt_write_data_tp;
typedef struct tag_nt_write_data_t
{
	char *name;
	char *mail;
	char *msg;
	wchar_t *status_msg;
	wchar_t *result_html;
	nt_link_tp cookies;
} nt_write_data_t;

extern nt_write_data_tp nt_write_data_alloc();
extern void nt_write_data_free(nt_write_data_tp ptr);

extern nt_2ch_model_tp nt_2ch_model_alloc();
extern nt_category_tp nt_category_alloc(
		nt_2ch_model_tp modelp, const wchar_t *name);
extern nt_board_tp nt_board_alloc( nt_category_tp categoryp, 
		const wchar_t *name, const wchar_t *addressp);
extern nt_thread_tp nt_thread_alloc(
		nt_board_tp boardp, const wchar_t *name,
		const wchar_t *file_name, int num_res);
extern nt_res_tp nt_res_alloc(nt_thread_tp	threadp, 
		const wchar_t *name, const wchar_t *mail, 
		const wchar_t *misc, const wchar_t *msg);

extern void nt_2ch_model_free(nt_2ch_model_tp ptr);
extern void nt_category_free(nt_category_tp ptr);
extern void nt_board_free(nt_board_tp ptr);
extern void nt_board_children_free(nt_board_tp ptr);
extern void nt_thread_free(nt_thread_tp ptr);
extern void nt_thread_children_free(nt_thread_tp ptr);
extern void nt_res_free(nt_res_tp ptr);
extern void nt_res_msg_free(nt_res_tp ptr);

extern BOOL parse_board_menu(nt_2ch_model_tp modelp,
		const wchar_t *linep);
extern BOOL parse_board(nt_board_tp boardp, const wchar_t *linep);
extern BOOL parse_thread(nt_thread_tp boardp, const wchar_t *linep);
extern int parse_res_msg(nt_res_tp resp, size_t colmns);

extern void nt_set_selected_board(nt_2ch_model_tp modelp,
		nt_category_tp categoryp, nt_board_tp boardp);
extern void nt_set_selected_thread(nt_2ch_model_tp modelp, nt_thread_tp threadp);

#endif /* _MODEL_2CH_H_ */
