#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <wchar.h>

#include "utils/nt_std_t.h"
#include "utils/text.h"
#include "_2ch/model_2ch.h"

static nt_category_tp get_last_category(nt_2ch_model_tp modelp);

int parse_res_msg(nt_res_tp resp, size_t colmns)
{
	int i, len, start, lines;
	wchar_t ch;
	wchar_t *buf, *cptr;
	int offset, extend_ch, buflen;
	nt_link_tp linkp;
	int consume_colmns;

	assert(resp->msg);

	nt_res_msg_free(resp);
	resp->msg_line_num = 0;

	len = wcslen(resp->msg);

	if(len == 0)
		return 0;
	buf = malloc(sizeof(wchar_t) * (len + 11));
	if(!buf)
		return 0;
	buflen = len+11;
	wcscpy(buf, resp->msg);

	lines = 0;
	extend_ch = 0;	
	start = 0;
	consume_colmns = 0;
	for(i = 0; i < len; i++){
		ch = buf[i];
		switch(ch){
		case L'&':
			if(len > (i+5)){
				if(buf[i+1] == L'q' &&
					buf[i+2] == L'u' &&
					buf[i+3] == L'o' &&
					buf[i+4] == L't' &&
					buf[i+5] == L';'){
					if(nt_w_str_move(
							buf+i, buflen-i, 6, -5)){
						buf[i] = L'\"';
						len -= 5;
						break;
					}else{
						goto END_FOR;
					}
					break;
				}
			}
			if(len > (i+4)){
				if(buf[i+1] == L'a' &&
					buf[i+2] == L'm' &&
					buf[i+3] == L'p' &&
					buf[i+4] == L';'){
					if(nt_w_str_move(
							buf+i, buflen-i, 5, -4)){
						buf[i] = L'&';
						len -= 4;
						break;
					}else{
						goto END_FOR;
					}
					break;
				}
			}
			if(len > (i+3)){
				if(buf[i+1] == L'g' &&
					buf[i+2] == L't' &&
					buf[i+3] == L';'){
					if(nt_w_str_move(
							buf+i, buflen-i, 4, -3)){
						buf[i] = L'>';
						len -= 3;
						break;
					}else{
						goto END_FOR;
					}
					break;
				}else if(buf[i+1] == L'l' &&
					buf[i+2] == L't' &&
					buf[i+3] == L';'){
					if(nt_w_str_move(
							buf+i, buflen-i, 4, -3)){
						buf[i] = L'<';
						len -= 3;
						break;
					}else{
						goto END_FOR;
					}
					break;
				}
			}
			
			goto DEF_LABEL; 
		case L'<': 
			if(len > (i+3) && buf[i+1] == L'b' &&
					buf[i+2] == L'r' &&
					buf[i+3] == L'>'){
				cptr = buf + start;
				buf[i] = L'\0';
				linkp = nt_link_add_data(
						resp->msg_line_linkp, cptr);
				if(!linkp)
					goto END_FOR;
				if(resp->msg_line_linkp == NULL)
					resp->msg_line_linkp = linkp;

				consume_colmns = 0;
				lines++;
				start = i + 4;
				i += 3;
				break;
			}else if(len > (i+7) && buf[i+1] == L'a' &&
					buf[i+2] == L' ' &&
					buf[i+3] == L'h' &&
					buf[i+4] == L'r' &&
					buf[i+5] == L'e' &&
					buf[i+6] == L'f' &&
					buf[i+7] == L'='){
				cptr = wcschr(buf+i+8, L'>');
				if(cptr){
					offset = (cptr + 1) - &(buf[i]);
					if(nt_w_str_move(
							buf+i, buflen-i, offset, -1*offset)){
						len -= offset;
						i--;
						break;
					}else{
						goto END_FOR;
					}
				}
			}else if(len > (i+3) && buf[i+1] == L'/' &&
					buf[i+2] == L'a' &&
					buf[i+3] == L'>'){
				if(nt_w_str_move(
						buf+i, buflen-i, 4, -4)){
					len -= 4;
					i--;
					break;
				}else{
					goto END_FOR;
				}
			}
		// fall through
		default:
DEF_LABEL:
			if(ch > 128)
				offset = 2;
			else
				offset = 1;

			if(consume_colmns + offset > colmns){
				if(nt_w_str_move(buf+i, buflen-i, 0, 1)){
					cptr = buf + start;
					buf[i] = L'\0';
					linkp = nt_link_add_data(
							resp->msg_line_linkp, cptr);
					if(!linkp)
						goto END_FOR;
					if(resp->msg_line_linkp == NULL)
						resp->msg_line_linkp = linkp;
					
					consume_colmns = 0;
					lines++;
					start = i + 1;
				}else{
					goto END_FOR;
				}
				extend_ch++;
				if(extend_ch == 10)
					goto END_FOR;
			}else{
				consume_colmns += offset;
			}
			break;
		}/* end switch */
	} /* end for */
END_FOR:
	if(consume_colmns > 0){
		cptr = buf + start;
		buf[i] = L'\0';
		linkp = nt_link_add_data(
				resp->msg_line_linkp, cptr);
		if(linkp){
			if(resp->msg_line_linkp == NULL)
				resp->msg_line_linkp = linkp;
			lines++;
		}
	}
	resp->msg_line_num = lines;
	return lines;
}


BOOL parse_thread(nt_thread_tp threadp, const wchar_t *linep)
{
	wchar_t buf[1024*3+1];
	nt_res_tp resp;
	wchar_t *cptr1, *cptr2, *cptr3, *cptr4;
	wchar_t *name, *mail, *misc, *msg;
	if(!linep)
		return FALSE;
	int len = wcslen(linep);
	if(len <= 0)
		return FALSE;
	if(len >= sizeof(buf))
		return FALSE;

	wcscpy(buf, linep);
	cptr1 = wcsstr(buf, L"<>");
	if(!cptr1)
		return FALSE;

	cptr2 = wcsstr(cptr1+2, L"<>");
	if(!cptr2)
		return FALSE;

	cptr3 = wcsstr(cptr2+2, L"<>");
	if(!cptr3)
		return FALSE;

	cptr4 = wcsstr(cptr3+2, L"<>");
	if(cptr4)
		*cptr4 = L'\0';

	name = buf;
	mail = cptr1 + 2;
	misc = cptr2 + 2;
	msg = cptr3 + 2;
	*cptr1 = *cptr2 = *cptr3 = L'\0';

	name = buf;

	resp = nt_res_alloc(threadp, name, mail, misc, msg);
	if(!resp)
		return FALSE;
	threadp->num_res++;
	resp->seq_no = threadp->num_res;

	return TRUE;
}


BOOL parse_board(nt_board_tp boardp, const wchar_t *linep)
{
	wchar_t buf[256+1];
	nt_thread_tp threadp;
	wchar_t *cptr1, *cptr2, *cptr3;
	int len, num_res;

	len = wcslen(linep);
	if(sizeof(buf)-1 < len)
		return FALSE;
	if(len >= sizeof(buf))
		return FALSE;

	wcscpy(buf, linep);
	cptr1 = wcsstr(buf, L"<>");
	if(!cptr1)
		return FALSE;
	*cptr1 = L'\0';
	cptr1 += 2;
	cptr2 = wcsrchr(cptr1, L'(');
	if(cptr2)
		cptr3 = wcsrchr(cptr2, L')');
	if(cptr2 && cptr3){
		*cptr2 = L'\0';
		*cptr3 = L'\0';
		num_res = wcstol(cptr2+1, NULL, 0);
	}else{
		num_res = 0;
	}
	threadp = nt_thread_alloc(boardp, cptr1, buf, num_res);
	if(!threadp)
		return FALSE;
	/* threadp = malloc(sizeof(nt_thread_t));
	if(!threadp)
		return FALSE;

	threadp->name = nt_w_trim(cptr1);
	threadp->address = nt_w_trim(buf);
	threadp->num_res = num_res; */
	return TRUE;
}


BOOL parse_board_menu(nt_2ch_model_tp modelp,
		const wchar_t *linep)
{

	wchar_t name[1024*2];
	int len;
	wchar_t *cptr1, *cptr2, *cptr3, *cptr4;
	wchar_t *addressp;
	nt_category_tp categoryp;
	int offset;

	assert(modelp);
	assert(linep);

	cptr1 = wcsstr(linep, L"<BR><B>");
	if(cptr1){
		cptr2 = wcsstr(cptr1, L"</B><BR>");
		if(!cptr2)
			return FALSE;
		cptr1 += 7;
		len = cptr2 - cptr1;
		wcsncpy(name, cptr1, len);
		name[len] = L'\0';
		if(!nt_category_alloc(modelp, name))
			return FALSE;
		return TRUE;
	}
	cptr1 = wcsstr(linep, L"<A HREF=");
	if(cptr1 == linep){
		cptr2 = wcsstr(cptr1, L"/>");
		if(!cptr2){
			cptr2 = wcsstr(cptr1,L".machi.to");
			if(!cptr2)
				return FALSE;
			cptr2 = wcsstr(cptr1, L" TARGET=_blank>");
			if(!cptr2)
				return FALSE;
			offset = 15;
		}else{
			offset = 2;
		}
		cptr3 = wcsstr(cptr2, L"</A>");
		if(!cptr3)
			return FALSE;
		cptr1 += 8;
		len = cptr2 - cptr1;
		wcsncpy(name, cptr1, len);
		name[len] = L'\0';
		addressp = name;
		cptr2 += offset;
		cptr4 = &(name[len+1]);
		len = cptr3 - cptr2;
		wcsncpy(cptr4, cptr2, len);
		cptr4[len] = L'\0';
		categoryp = get_last_category(modelp);
		if(!categoryp)
			return FALSE;
		if(!nt_board_alloc(categoryp, cptr4, addressp))
			return FALSE;
		return TRUE;
	}
	return FALSE;
}

static nt_category_tp get_last_category(nt_2ch_model_tp modelp)
{
	nt_category_tp categoryp;

	nt_link_tp linkp = modelp->categorylistp;
	if(!linkp)
		return NULL;
	linkp = linkp->prev;
	categoryp = (nt_category_tp)linkp->data;
	return categoryp;
}
