#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>

#define _GNU_SOURCE
#include <getopt.h>

#include "env.h"
#include "utils/nt_std_t.h"
#include "utils/file.h"
#include "utils/text.h"

char LOG_PATH[1024];
char USR_PATH[1024];
char USR_COOKIE_PATH[1024];
char EDITOR_CMD[1024]; 
int FORCE_REFRESH = 0; 
static char *app_name = "ntch";
static char *version_name = "1.0.1";
static char *def_editor_cmd = "vi";

char *MARU_ID;
char *MARU_PW;

struct option longopts[] = {
	{"refresh-screen", 0, NULL, 'r'},
	{"version", 0, NULL, 'v'},
	{"help", 0, NULL, 'h'},
	{"editor", 1, NULL, 'e'},
	{"out-path", 1, NULL, 'o'}
};

extern void print_help();
extern BOOL read_resource(const char *path);

int set_option(int argc, char* argv[])
{
	int opt ,len;
	uid_t uid;
	struct passwd *pw;
	char buf[256];

	MARU_ID = NULL;
	MARU_PW = NULL;

	uid = getuid();
	pw = getpwuid(uid);
	if(!pw){
		perror("Could not find user info.(home dir)\n");
		return -1;
	}
	sprintf(USR_PATH, "%s/.ntch", pw->pw_dir);
	sprintf(USR_COOKIE_PATH, "%s/cookie", USR_PATH);

	sprintf(buf, "%s/.ntchrc", pw->pw_dir);
	if(!read_resource(buf)){
		fputs(
			"Could not read user's resource file. \n\tuse default.\n", 
			stderr);
	}

	strcpy(LOG_PATH, "./log");
	strcpy(EDITOR_CMD, def_editor_cmd); 

	if(!nt_mkdir(USR_PATH)){
		return -1;
	}

	while((opt = getopt_long(
			argc, argv, "hvro:", longopts, NULL)) != -1){

		switch(opt){
		case 'r':
			printf("screen refresh: on\n");
			FORCE_REFRESH = 1; 
			break;
		case 'v':
			printf("%s (NTCH) 2channel browser version - %s\n", 
				app_name , version_name);
			return 1;
		case 'h':
			print_help();
			return 1;
		case 'o':
			printf("output path: %s\n", optarg);
			len = strlen(optarg);
			if(len == 0)
				break;
			strcpy(LOG_PATH, optarg);
			if(LOG_PATH[len-1] != '/'){
				LOG_PATH[len++] = '/';
			}
			strcpy(LOG_PATH+len, "log");
			break;
		default:
			break;
		}
	}
	/*for(; optind < argc; optind++){
		fprintf(stderr, "Unrecognized argument %s\n",
					argv[optind]);
	}*/
	return 0;
}


extern BOOL read_resource(const char *path)
{
	FILE *fp;
	char *cptr, *key, *val;
	char buf[128];

	fp = fopen(path, "r");
	if(!fp)
		return FALSE;
	
	while(fgets(buf, sizeof(buf), fp)){
		cptr = strchr(buf, '=');
		if(!cptr)
			continue;

		*cptr = '\0';
		key = strstr(buf, "maru-id");
		if(key){
			val = cptr+1;
			MARU_ID = nt_trim(val);
			continue;
		}
		key = strstr(buf, "maru-pw");
		if(key){
			val = cptr+1;
			MARU_PW = nt_trim(val);
			continue;
		}
	}
	fclose(fp);
	return TRUE;
}
