<?php
    
    function rootDir(){
        // $rootDir = "../../" のような指定方法では認識されず "" になってしまう
        //return "../../"; // /X/NOA の場合
        return "../"; // /NOA の場合
    }
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        $array = explode("%xa;", $val); // DocMaker の Image 用
        $val = implode("\\'", $array);
        return $val;
    }
    
    function dirForOwnerAndFolder($owner, $folder, $subfolder){
        // $dir が無ければ作成
        $dir = rootDir()."Users";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        if ($owner){
            $dir = "$dir/$owner";
            if (! file_exists($dir)){
                // $dir が無ければ作成
                echo "($dir) is not exist, so I'll make directory. \n"; //##
                mkdir($dir);
            }
        }
        $dir = "$dir/$folder";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        if (strlen($subfolder) > 0){
            $dir = "$dir/$subfolder";
            if (! file_exists($dir)){
                // $dir が無ければ作成
                echo "($dir) is not exist, so I'll make directory. \n"; //##
                mkdir($dir);
            }
        }
        
        return $dir;
    }
    
    function timeStamp(){
        date_default_timezone_set("Asia/Tokyo");

        return date("YmdHi",time()); // 201305040805 型式
    }
    

    
    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) {
     $key = $_REQUEST['key'];
     }
     ########################################## */
    
    $command = $_POST['command'];
    $owner = $_POST['owner'];
    $folder = $_POST['folder'];
    $filename = $_POST['filename'];
    $value = $_POST['value'];
    $value = decodeSTRING($value);
    
    if (strcmp($command,"PUT_ARCHIVE_FILE") == 0){
        echo "PUT_ARCHIVE_FILE"; //##
        
        $dir = dirForOwnerAndFolder($owner, $folder);
        $timestamp = timeStamp(); // 201305040805 型式
        $filename = "$dir/$timestamp$filename.txt";
        
        echo "filename: $filename "; //##
        echo "<SEPARATOR>";
        if (!$handle = fopen($filename, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "ERROR: Cannot open file ($filename)";
        } else {
            if (fwrite($handle, $value) === FALSE) {
                // オープンしたファイルに$buffを書き込む
                echo "ERROR: Cannot write to file ($filename)";
            } else {
                echo "メニュー構造を ($filename) に保存しました";
                fclose($handle);
            }
        }
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }
    
?>
