<?php
	
define('FPDF_FONTPATH','/Applications/MAMP/htdocs/FPDF/fpdf153/font/');
require('../FPDF/fpdf153/mbfpdf.php');

////////////////////////////////
// WRITE THIS FILE AS "S-JIS" //
////////////////////////////////

function shohouFormat($x, $y, $w, $value, $pdf){
	// e $value eLXg`ɕϊċLq
	$x += 8;
	$y += 5;
	$w -= 10;
	$h = 5;
	$pdf->SetFont(KOZMIN,'', 9);
	$pdf->SetXY($x, $y);
	$pdf->SetLeftMargin($x);
	
	$value = mb_convert_encoding($value, "SJIS", "UTF-8");
	
	$records = explode("<BR/>", $value);
	$count = count($records);
	$results = array();
	for ($i=0; $i < $count; $i++){
		$ln = trim($records[$i]);
		if (strlen($ln) == 0) continue;
        
        // s * ̂͌㔭iւ̕ύXs
        if (strpos($ln, "*") === 0)
            $ln = "*@".substr($ln, 1);
        else
            $ln = "@@$ln";
        $pdf->MultiCell($w, $h, $ln, 0, 'L');
	}
}

function wareki($currentDate){
	if (strlen($currentDate) == 0) return "@@@@N@ @ ";
	
	$ary = explode(" ", $currentDate);
	$array = explode("-", $ary[0]);
	$yy = $array[0] * 1;
	$mm = $array[1] * 1;
	$dd = $array[2] * 1;
	if ($yy > 1988){
		$yy -= 1988;
		$nengou = "".$yy;
	}
	else if ($yy > 1925) {
		$yy -= 1925;
		$nengou = "a".$yy;
	}
	else if ($yy > 1911) {
		$yy -= 1911;
		$nengou = "吳".$yy;
	}
	else {
		$yy -= 1867;
		$nengou = "".$yy;
	}
	return $nengou."N".$mm."".$dd."";
}

function kikanDate($currentDate){
	$ary = explode(" ", $currentDate);
	$array = explode("-", $ary[0]);
	$yy = $array[0] * 1;
	$mm = $array[1] * 1;
	$dd = $array[2] * 1;
	$time = gmmktime(0,0,0,$mm,$dd,$yy);
	$date = getdate($time + 60*60*24*3);
	$heisei = $date[year] - 1988;
	return "".$heisei."N".$date[mon]."".$date[mday]."܂";
}

function insFrame($x, $y, $w, $h, $pdf, $labelWidth, $label, $value){
	$pdf->SetFont(KOZMIN,'', 6.5);
	$pdf->SetXY($x, $y);
	$pdf->Cell($labelWidth, $h, $label, 1, 0, 'L');
	
	$pdf->SetFont(KOZMIN,'B', 9);
	$pdf->SetXY($x + $labelWidth, $y);
	$pdf->Cell($w - $labelWidth, $h, $value, 1, 0, 'C');
}

function stamp($x, $y, $pdf){
	$pdf->Rect($x, $y, 4, 4, '');
	$pdf->SetFont(KOZMIN,'', 6);
	$pdf->Text($x+1, $y+3, "");
}



$info = $_GET['info']; $info = stripslashes($info);
$doctorName = $_GET['doctorName']; $doctorName = stripslashes($doctorName);
$value = $_GET['value']; $value = stripslashes($value);

// JSON `̕Azzɕϊ
$infoObj = json_decode($info, true);

// dqⳂ瑗ꂽp[^pϐɓWJ
$userName = mb_convert_encoding($infoObj["loginName"], "SJIS", "UTF-8");
$currentDate = $infoObj['currentDate'];
$name = mb_convert_encoding($infoObj["kanjiName"], "SJIS", "UTF-8")." l";
$furigana = mb_convert_encoding($infoObj["furigana"], "SJIS", "UTF-8");
$sex = mb_convert_encoding($infoObj["sex"], "SJIS", "UTF-8");
$hospitalName = mb_convert_encoding($infoObj["hospitalName"], "SJIS", "UTF-8");
$hospitalAddress = mb_convert_encoding($infoObj["hospitalAddress"], "SJIS", "UTF-8");
$hospitalPhone = mb_convert_encoding($infoObj["hospitalPhone"], "SJIS", "UTF-8");
	
$todoufukenBangou = mb_convert_encoding($infoObj["todoufukenBangou"], "SJIS", "UTF-8");
$tensuuhyouBangou = mb_convert_encoding($infoObj["tensuuhyouBangou"], "SJIS", "UTF-8");
$iryoukikanCode = mb_convert_encoding($infoObj["iryoukikanCode"], "SJIS", "UTF-8");
	
$birthDay = wareki($infoObj["birthDay"]);
$koufubi = wareki($currentDate);
$kikan = kikanDate($currentDate);
$shubetsu = mb_convert_encoding($infoObj["shubetsu"], "SJIS", "UTF-8");
$kubun = mb_convert_encoding($infoObj["family"], "SJIS", "UTF-8");
$rate = mb_convert_encoding($infoObj["paymentRatio"], "SJIS", "UTF-8");
$hokenshaBangou = mb_convert_encoding($infoObj["hokenshaBangou"], "SJIS", "UTF-8");
$kigou = mb_convert_encoding($infoObj["kigou"], "SJIS", "UTF-8");
$bangou = mb_convert_encoding($infoObj["bangou"], "SJIS", "UTF-8");
$kouhiFutanBangou = mb_convert_encoding($infoObj["kouhiFutanBangou"], "SJIS", "UTF-8");
$jyukyuuBangou = mb_convert_encoding($infoObj["jyukyuuBangou"], "SJIS", "UTF-8");
$doctorName = mb_convert_encoding($doctorName, "SJIS", "UTF-8");
	
$prescription = $value;



$pdf=new MBFPDF('P', 'mm', array(180, 256)); // B5
$topMargin = 0;
$leftMargin = 26;
$width = 125;
$contentsHeight = 85; //65;
$labelWidth = 17;
$labelFontSize = 8;

//$pdf=new MBFPDF('P', 'mm', 'A5');
$pdf->AddMBFont(KOZMIN ,'SJIS');
$pdf->AddMBFont(GOTHIC ,'SJIS');
$pdf->AddMBFont(BIG5, 'SJIS');

$pdf->Open();
$pdf->AddPage();


// TITLE
$y = $topMargin;
$pdf->SetXY(0, $y);
$pdf->SetFont(KOZMIN,'B', $labelFontSize+3);
$pdf->Cell($width-20, 5, "@@", 0, 0, 'C');
$pdf->SetXY(50, $y);
$pdf->SetFont(KOZMIN,'B', $labelFontSize);
$pdf->Cell($width, 5, "ȉⳂ́Aǂ̕یǂłLłj", 0, 0, 'C');

// Public Ins
$y += 6; //8;
$frameTopY = $y;
$height1 = 7;
insFrame($leftMargin, $y, $width/2-1, $height1, $pdf, $labelWidth, "Sԍ", $kouhiFutanBangou);

// Public Ins
$y += $height1;
insFrame($leftMargin, $y, $width/2-1, $height1, $pdf, $labelWidth, "󋋎Ҕԍ", $jyukyuuBangou);

// ӂ肪
$height2 = 6;
$y += $height2;
$pdf->SetFont(KOZMIN,'', 7);
$pdf->SetXY($leftMargin + $labelWidth, $y);
$pdf->Cell($width/2 - $labelWidth, $height2+1, $furigana, 0, 0, 'C');

// 
$height3 = 10;
insFrame($leftMargin, $y+1, $width/2-1, $height3, $pdf, $labelWidth, "", "");
$pdf->SetXY($leftMargin + $labelWidth, $y);
$pdf->Cell($width/2 - $labelWidth, $height2+10, $name, 0, 0, 'C');
$y += 1;

// N
$y += $height3;
$pdf->SetXY($leftMargin, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->Cell($labelWidth, $height2, "N", 1, 0, 'L');
$pdf->SetXY($leftMargin+$labelWidth, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
$pdf->Cell($width/2-$labelWidth*2-1, $height2, $birthDay, 1, 0, 'C');

$pdf->SetXY($leftMargin+$labelWidth+$width/2-$labelWidth*2-1, $y);
$pdf->Cell($labelWidth, $height2, $sex, 1, 0, 'C');

// ی敪
$height4 = 9;
$y += $height2;
$pdf->SetXY($leftMargin, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->Cell($labelWidth, $height2, "ی敪", 1, 0, 'L');
$pdf->SetXY($leftMargin+$labelWidth, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
if (strlen($kubun) > 0)
	$hokenShubetsu = $shubetsu."F".$kubun;
else
	$hokenShubetsu = $shubetsu;
$pdf->Cell($width/2-$labelWidth*2-1, $height2, $hokenShubetsu, 1, 0, 'C');

// ҕS
$x = $leftMargin+$labelWidth+$width/2-$labelWidth*2-1;
$pdf->SetXY($x, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
$pdf->Cell($labelWidth, $height2, "$rate ", 1, 0, 'C');

// tN
$y += $height2;
insFrame($leftMargin, $y, $width/2-1, $height2, $pdf, $labelWidth, "tN", $koufubi);

// gp
$y += $height2;
$pdf->SetXY($leftMargin, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->Cell($labelWidth, $height4, "gp", 1, 0, 'L');

$pdf->Rect($leftMargin, $y, $width/2-1, $height4, '');
$pdf->SetXY($leftMargin+$labelWidth, $y);
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->Cell($width/2-$labelWidth, $height4-3, $kikan, 0, 0, 'C');
$pdf->SetXY($leftMargin+$labelWidth-1, $y+5);
$pdf->SetFont(KOZMIN,'', $labelFontSize-2);
$pdf->Cell($width/2-$labelWidth, 3, "t܂߂Sȓɖǂւ", 0, 0, 'C');

// یҔԍ
$y2 = $frameTopY;
insFrame($leftMargin+$width/2, $y2, $width/2, $height1, $pdf, $labelWidth, "یҔԍ", $hokenshaBangou);
// Lԍ
$x2 = $leftMargin+$width/2;
$y2 += $height1;
$w = $labelWidth + ($width/2 - $labelWidth) / 2;
insFrame($x2, $y2, $w, $height1, $pdf, $labelWidth, "LEԍ", $kigou);
$pdf->SetXY($x2+$w, $y2);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
$pdf->Cell($width/2-$w, $height1, $bangou, 1, 0, 'C');

// ADDRESS
$x2 = $leftMargin+$width/2+3;
$y2 += $height1+1;
$adWidth = 75;
$adHeight = 6;
$pdf->SetXY($x2, $y2);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
$pdf->Cell($adWidth, $adHeight, $hospitalAddress, 0, 0, 'L');
$y2 += 7;
$pdf->SetXY($x2, $y2);
$pdf->Cell($adWidth, $adHeight, $hospitalName, 0, 0, 'L');
$y2 += 4;
$pdf->SetXY($x2, $y2);
$pdf->Cell($adWidth, $adHeight, "dbF$hospitalPhone", 0, 0, 'L');
$y2 += 7;
$pdf->SetXY($x2, $y2);
$pdf->Cell($adWidth, $adHeight, "یF$userName", 0, 0, 'L');

//  }[N`
stamp($leftMargin+$width-5, $y2, $pdf);

// gp
$y2 += 3 + $height2;
$x2 = $leftMargin+$width/2;
$pdf->SetXY($x2, $y2);
$pdf->Rect($x2, $y2, $width/2, $height4, '');
	
$pdf->SetFont(KOZMIN,'', $labelFontSize-2);
$pdf->SetXY($x2, $y2);
$pdf->Cell($adWidth, $adHeight, "s{ԍ", 0, 0, 'L');
$pdf->SetXY($x2+15, $y2);
$pdf->Cell($adWidth, $adHeight, "_\ԍ", 0, 0, 'L');
$pdf->SetXY($x2+35, $y2);
$pdf->Cell($adWidth, $adHeight, "Ë@փR[h", 0, 0, 'L');

$pdf->SetFont(KOZMIN,'', $labelFontSize+3);
$y2 += 4;
$pdf->SetXY($x2, $y2);
$pdf->Cell($adWidth, $adHeight, $todoufukenBangou, 0, 0, 'L');
$pdf->SetXY($x2+15, $y2);
$pdf->Cell($adWidth, $adHeight, $tensuuhyouBangou, 0, 0, 'L');
$pdf->SetXY($x2+35, $y2);
$pdf->Cell($adWidth, $adHeight, $iryoukikanCode, 0, 0, 'L');
	
// e
$pdf-> SetFillColor(100, 220, 180);
$x = $leftMargin;
$y += $height4;
$pdf->Rect($x, $y, $width, $contentsHeight, '');
shohouFormat($x, $y, $width, $prescription, $pdf);
// ύXs̘g
$pdf->Rect($x, $y, 12, $contentsHeight, ''); 
$pdf->SetXY($leftMargin, $y+2);
$pdf->SetFont(KOZMIN,'', 7);
$pdf->Cell(50, 0, "ύXs", 0, 0, 'L');
$pdf->SetXY($leftMargin + 12, $y+2);
$pdf->SetFont(KOZMIN,'', 7);
$pdf->Cell(50, 0, "ύXs  ̂܂́u㔭i֕ύXsvł", 0, 0, 'L');

// l
$pdf-> SetFillColor(100, 220, 180);
$y += $contentsHeight;
$bikouHeight = 30;
$pdf->Rect($leftMargin, $y, $width, $bikouHeight, '');

$pdf->SetXY($leftMargin, $y+1);
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->Cell(50, 4, "l", 0, 0, 'L');

// 㔭iւ̕ύX
$x2 = $leftMargin+$width*45/110;
$y2 = $y + 1;
$pdf->SetFont(KOZMIN,'', $labelFontSize);
$pdf->SetXY($x2, $y2);
$pdf->Cell($width/2+2, 6, "ȉ֋L󂪂Ό㔭i֕ύXs̖܂", 0, 0, 'L');
//  }[N`
stamp($leftMargin+$width-5, $y2+8, $pdf);
$pdf->SetXY($x2, $y2+7);
$pdf->SetFont(KOZMIN,'', $labelFontSize+1);
$pdf->Cell($width/2+2, 6, "ی㏐F $doctorName", 0, 0, 'L');

// یҔԍ
$y2 = $y + $bikouHeight - $height1 * 2;

$x1 = $leftMargin;
$w = $width/2;
$w1 = $width*2/11;
insFrame($x1, $y2, $w, $height1, $pdf, $w1, "ܔN", $kouhiFutanBangou2);
$pdf->SetXY($x1+$w1, $y2);
$pdf->SetFont(KOZMIN,'', $labelFontSize-2);
$pdf->Cell($w-25, $height1, "@@ @N@@ @@@ @", 0, 0, 'C');
$x2 = $leftMargin + $w;
insFrame($x2, $y2, $w, $height1, $pdf, $w1, "SҔԍ", $kouhiFutanBangou2);

$y2 = $y + $bikouHeight - $height1;
insFrame($x1, $y2, $w, $height1, $pdf, $w1, "یǖ܎t", $kouhiFutanBangou2);
//  }[N`
stamp($x2-5, $y2+2, $pdf);
insFrame($x2, $y2, $w, $height1, $pdf, $w1, "󋋎Ҕԍ", $jyukyuuBangou2);

$pdf->Output();

?>
