
////////////////////////////////
///// NOA へ問い合わせて得る値 /////

function _noa(){
	// window.opener が NOA なら NOA を返す
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.opener && (window.top.noa)){
        return window.top.noa;
    } else {
        //alert("親として NOA が見つかりません");
        return null;
    }
}

function patientId(){
	if (_noa()){
        return (_noa().noaType() == "NOA8G")
            ? _noa().patient_id() : _noa().patientId();
	} else
		return "";
}

function anotherId(){
	if (_noa()){
		var aid = _noa().valueForTag("PatientTable.anotherId");
		return (aid) ? aid : "";
	} else
		return "";
}

function patientKanjiName(){
	if (_noa())
		return _noa().valueForTag("NameSection.patientKanjiName");
	else 
		return "";
}

var _owner;
function setOwner(name){
	_owner = name;
}
function owner(){
	if (_owner)
		return _owner;
	else if (_noa()){
		setOwner(_noa().owner());
		return _noa().owner();
	} else
		return "";
}

///// NOA へ問い合わせて得る値 /////
////////////////////////////////

var _records;
function setRecords(obj){
	_records = obj;
}
function records(){
	return _records;
}
function recordForId(pid){
	// pid の含まれるレコードを返す
	for (num in _records){
		var rec = _records[num];
		if (rec.patientId == pid)
			return rec;
	}
	return null;
}

/////////////////////////////////////////////
///// neuron.js を介したサーバとの通信 ///////////

function gotRemind(answer){
	// リマインダーの内容をサーバから受け取る
	//alert("=== gotRemind\n"+answer); //##
	
	// CONTENTS
	var obj = eval('(' + answer + ')');
	setRecords(obj);
	showRemind();
}
function getRemind(){
	// リマインダーの内容をリクエスト
	var pid = "";
	NRgetRemind(pid, 0, owner(), gotRemind);
}

function puttedRemind(answer){
	// リマインダーの内容をサーバから受け取る
	//alert("=== puttedRemind\n"+answer); //##
	closeFloatPanel();
	getRemind();
}
function addRecord(pid){
	// pid のデータをサーバへ書き込む
	var memo = document.getElementById("memo").value;
	
	NRputRemind(pid, 0, owner(), memo, puttedRemind);
}

function deleteRemind(pid){
	// pid のデータをサーバから削除
	var name = recordForId(pid).patientKanjiName;
	
	if (confirm(pid + " " + name + " のレコードを削除していいですか")){
		// 空データを送れば削除になる
		NRputRemind(pid, 0, owner(), "", puttedRemind);
	}
}

///// neuron.js を介したサーバとの通信 ///////////
/////////////////////////////////////////////


function showEditPanel(pid){
	// pid の編集パネルを開く
	var name = "";
	var value = "";
	var date = "";
	var rec = recordForId(pid);
    
	if (rec){
		name = rec.patientKanjiName;
		value = rec.dataString;
		date = " ( " + rec.updateTime + " )";
	} else if (pid == patientId()){
		name = patientKanjiName();
	}

	// データ編集パネルを生成
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
	
	var tr = newTR(tbl, "", "");
	tr.style.fontSize = "10pt";
	var td = newTD(tr, "", pid + " " + name + date);
	td.style.textAlign = "center";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var ta = newTEXTAREA(td, "memo", 50, 10, value);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "addRecord('" + pid + "')");
	
	var x = 5;
	var y = 5;
	openFloatPanel(tbl, x, y, "編集パネル");
    
    ta.focus();
}

function newRecord(){
	// 新規レコードを追加
	if (! _owner){
		var owner = prompt("owner を入力してください", "");
		if (owner.length > 0)
			setOwner(owner);
		else
			return;
	}
	
	var pid = prompt("覚書の対象となる「カルテID」", patientId());
	if (pid.length){
		showEditPanel(pid);
	}
}

function showRemind(){
	// remind のコンテンツを表示
	var elm = document.getElementById("historyArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "10pt";
	
	// TITLE
	var tr = newTR(tbl, "", "");
    tr.style.fontSize = "9pt";
    tr.style.backgroundColor = "#eee";
	var td = newTD(tr, "", "カルテID");
	var td = newTD(tr, "", "氏名");
	var td = newTD(tr, "", "メモ");
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";

	var obj = records();
	if (obj){
		for (num in obj){
			var tr = newTR(tbl, "", "");
			var rec = obj[num];
			
			var td = newTD(tr, "", rec.patientId);
			var action = "showEditPanel('" + rec.patientId + "')";
			td.setAttribute("onclick", action);
			td.setAttribute("onmouseover", "setColor(this, '#ff0', '#00f')");
			td.setAttribute("onmouseout", "resetColor(this, '#000', '#fff')");
			td.style.padding = "2px 2px";

			var td = newTD(tr, "", rec.patientKanjiName);
			td.style.padding = "2px 2px";
			
			var td = newTD(tr, "", rec.dataString);
			td.style.backgroundColor = "#ffc";
			td.style.padding = "2px 2px";
			td.style.border = "thin solid #ddd";
			
			var td = newTD(tr, "", "");
			var im = newIMAGE(td, "", "./remove-field.png", "?");
			im.style.height = "12px";
			im.setAttribute("onclick", "deleteRemind('" + rec.patientId + "')");
		}
	}
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "... 新規メモを追加");
	td.setAttribute("colspan","3");
	td.style.color = "#00f";
	td.setAttribute("onmouseover", "setColor(this, '#ff0', '#00f')");
	td.setAttribute("onmouseout", "resetColor(this, '#00f', '#fff')");
	td.setAttribute("onclick", "newRecord()");
	var td = newTD(tr, "", "");
}

function help(){
	// 別途ヘルプをパネル表示
	window.open("./reminderHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initReminder(){
	var elm = document.getElementById("base");
	var tbl = newTABLE(elm, "base-table");
	
	// header
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    var tbl2 = newTABLE(td, "base-table");
    var tr = newTR(tbl2, "title-bar", "");
	var td = newTD(tr, "left-side", "リマインダー");
	var td = newTD(tr, "right-side", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";

	// リスト表示エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "historyArea", "");

	// footer
	var tr = newTR(tbl, "title-bar", "");
	var td = newTD(tr, "left-side", version() + "　取扱: " + owner());
	
	// 過去の伝票を検索しリストアップ
	getRemind();
}

function version(){
	return "Ver.121006";
}
