

function owner(){
    return document.getElementById("_owner").value;
}

function hospitalId(){
    return document.getElementById("_hospitalId").value;
}

function patientId(){
    return document.getElementById("_patientId").value;
}

function currentDate(){
    return document.getElementById("_currentDate").value;
}

function tagObjects(){
    // 表示するタグのオブジェクトを返す
    var obj = new Object();
    
    obj["NameSection.patientKanjiName"] = "氏名";
    obj["NameSection.patientKanaName"] = "ふりがな";
    obj["AddressSection.address"] = "住所";
    obj["AddressSection.phone"] = "電話";
    
    obj["HealthInsurance.shubetsu"] = "種別";
    obj["HealthInsurance.kubun"] = "区分";
    obj["HealthInsurance.paymentRatio"] = "負担率";
    obj["HealthInsurance.kigou"] = "記号";
    obj["HealthInsurance.bangou"] = "番号";
    obj["HealthInsurance.ownerNumber"] = "保険者番号";
    obj["HealthInsurance.ownerName"] = "保険者名";
    
    obj["ProgressSection.subject"] = "主訴";
    obj["ProgressSection.disease"] = "病名";
    obj["ProgressSection.prescription"] = "処方";
    obj["ProgressSection.treatment"] = "診療";
    obj["FrontTable.plan"] = "実施予定";
    
    return obj;
}

function labelForTag(tag){
    return tagObjects()[tag];
}

function tagArray(){
    // 表示するタグの配列を返す
    var array = new Array();
    var obj = tagObjects();
    
    for (tag in obj){
        array.push(tag);
    }
    
    return array;
}

/////////////////////////////////////////////////////
// Ajax /////////////////////////////////////////////

function gotPage(answer){
	// tagArray にデータを入れたものが返ってくる
	// alert("gotPage ===\n"+answer); //##
    
    var obj = eval('(' + answer + ')');
    //alert("gotPage ===\n"+encodeObject(obj)); //##
    
    showContents(obj);
}
function getPage(dateTime){
	// データをサーバへリクエスト
	var st = tagArray().join(",");
    
    // FRONT から Viewer で検索する場合、FRONT の currentDate は NOA の currentDate
    // より早いタイムスタンプなので、目的のカルテデータより以前のものがヒットしてしまう。
    // そこで currentDate を後にずらした時刻で検索する
    var date = dateTime.substr(0, 10);
    dateTime = date + " 23:59:59";
    
	NRGetPage(owner(), patientId(), dateTime, "", st, gotPage);
}

// Ajax /////////////////////////////////////////////
/////////////////////////////////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

function putWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage へ記憶
    var array = new Array();
	array.push(window.screenLeft); // x
	array.push(window.screenTop - 22); // y
	array.push(window.outerWidth); // w
	array.push(window.outerHeight); // h
    window.localStorage["viewerWindowSize"] = array.join(",");
    
    //showFadeoutInfo("messageArea", "window のサイズと位置を記憶しました", 800);
}
function getWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["viewerWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////


function gotInsImage(answer){
    // 保険証画像パネルを開く
    //alert("gotInsViewer->"+answer); //##
    
    // var obj = JSON.parse(answer); // ### old MAC で動かない？ ###
    var obj = eval('(' + answer + ')');
    if (obj.files){
        // obj.files[0] は "02288001_20120412155531.JPG" 形式
        var path = obj.path + "/" + obj.files[0];
        
        window.open(path, "InsranceCardImage");
    }
}
function getInsImage(){
    // 保険証画像の path をリクエスト
    NRGetInsrance(patientId(), gotInsImage);
}

function showContents(obj){
    // コンテンツを表示
	var elm = document.getElementById("base");
    elm.innerHTML = "";
	var tbl = newTABLE(elm, "baseTable");
    tbl.style.fontSize = "11pt";
    
    // entryDate
    var tr = newTR(tbl, "title", "");
    var td = newTD(tr, "", "受診日時");
    td.style.paddingLeft = "10px";
    var td = newTD(tr, "", "");
	var tbl2 = newTABLE(td, "simpleTable");
    var tr = newTR(tbl2, "", "");
    var td = newTD(tr, "value", currentDate());
    var td = newTD(tr, "", "");
    td.style.textAlign = "right";
    td.style.padding = "0px 10px";
	var img = newIMAGE(td, "icon", "./zoomfit.png", "zoom");
	img.setAttribute("onclick","putWindowSize()");
	img.style.height = "16px";
	img.style.verticalAlign = "middle";
    
    // PatientId name ( furigana )
    var tr = newTR(tbl, "cell", "");
    var td = newTD(tr, "label", patientId());
    var name = obj["NameSection.patientKanjiName"];
    name = pureValue(name);
    var furigana = obj["NameSection.patientKanaName"];
    furigana = pureValue(furigana);
    var td = newTD(tr, "value", name + " ( " + furigana + " )");
    
    // tagArray の順序で表示
    var tarray = tagArray();
    for (num in tarray){
        var tag = tarray[num];
        if (tag == "pageStatus") continue; // Recorded at ... 2011-08-22 09:...
        if (tag == "NameSection.patientKanjiName") continue;
        if (tag == "NameSection.patientKanaName") continue;
        
        var isInsrance = false;
        if (tag.indexOf("HealthInsurance") >= 0) isInsrance = true;
        if (tag.indexOf("PublicInsurance") >= 0) isInsrance = true;
        
        var tr = newTR(tbl, "cell", "");
        var td = newTD(tr, "label", labelForTag(tag));
        var val = pureValue(obj[tag]);
        val = htmlForValue(val);
        var td = newTD(tr, "value", "");
        td.innerHTML = val;
        if (isInsrance) td.style.background = "#ffe";
    }
    
    // footer
    var tr = newTR(tbl, "title", "");
    var td = newTD(tr, "title", viewerVersion());
    var td = newTD(tr, "title", "");
    td.style.textAlign = "right";
    td.style.padding = "0px 10px";
    td.style.fontSize = "10pt";
    var bt = newBUTTON(td, "", "保険証画像");
    bt.setAttribute("onclick", "getInsImage()");
    var bt = newBUTTON(td, "", " 画面をとじる ");
    bt.setAttribute("onclick", "window.close()");
}

function initViewer(){
    // FRONT から起動する電子カルテビューア
    window.document.title = patientId() + " ( " + currentDate() + " )";
    
    getPage(currentDate());
}

function viewerVersion(){
    return "Ver.1201005";
}
