/*============================================================================*
 *  FILE: 
 *     msgwrite.c
 *
 *  Description: 
 *     Message write functions for NNsh. 
 *
 *===========================================================================*/
#define MSGWRITE_C
#include "local.h"

static void setBBSNameAndTime(UInt16 bbsType, Char *boardNick,
                              Char *buffer, UInt16 bufSize);
static void setFormParameters(Char *nick, Char *buffer, UInt16 bufSize,
                            Char *tempArea, UInt16 areaSize, Char *defSubmit);
static Char *checkWriteReply(Char *buffer, UInt32 bufSize, UInt32 command, UInt16 bbsType);
static Err create_outputMessageFile(FormType *diagFrm, Char *buffer,
                                    UInt32 bufSize, Char *boardNick, 
                                    Char *key, UInt16 bbsType);
static Err threadWrite_Message(void);


/*-------------------------------------------------------------------------*/
/*   Function : setBBSNameAndTime                                          */
/*                                               BBSƌݎݒ肷 */
/*-------------------------------------------------------------------------*/
static void setBBSNameAndTime(UInt16 bbsType, Char *boardNick,
                              Char *buffer, UInt16 bufSize)
{
    Int16    timeZone, dayLight;
    UInt32   dummy;

    // BBS̏o
    MemSet (buffer, bufSize, 0x00);
    if ((bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        StrCopy(buffer, "&BBS=");
    }
    else
    {
        StrCopy(buffer, "&bbs=");
    }
    StrCat (buffer, boardNick);

    // BBSꗗ̖ '/' ĂOB
    if (buffer[StrLen(buffer) - 1] == '/')
    {
        buffer[StrLen(buffer) - 1] = '\0';
    }

    // ݎ̏o
    if ((bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        StrCat (buffer, "&TIME=");
    }
    else
    {
        StrCat (buffer, "&time=");
    }

    // PalmOS version 4ȏ̂Ƃ́AUTCɕϊĂvZ
    if (NNshGlobal->palmOSVersion >= 0x04003000)
    {
        timeZone = PrefGetPreference(prefTimeZone);
        dayLight = PrefGetPreference(prefDaylightSavingAdjustment);
        dummy    = TimUTCToTimeZone(TimGetSeconds(), timeZone, dayLight);
        NUMCATI(buffer, dummy - TIME_CONVERT_1904_1970_UTC);
    }
    else
    {
        NUMCATI(buffer, TimGetSeconds() - TIME_CONVERT_1904_1970);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : setFormParameters                                          */
/*                                        tH[p[^擾 */
/*-------------------------------------------------------------------------*/
static void setFormParameters(Char *nick, Char *buffer,   UInt16 bufSize,
                              Char *tempArea, UInt16 areaSize, Char *defSubmit)
{
    Err          ret;
    Char        *ptr, *data, numBuf[16];
    NNshFileRef  fileRef;
    UInt32       readSize, fileSize, offset, num;

    // MtH[̃p[^͂
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        goto USE_DEFAULT;
    }

    // MbZ[WTCY擾
    GetFileSize_NNsh(&fileRef, &fileSize);

    // t@C̓ǂݏoʒuݒ肷
    if (fileSize <= bufSize)
    {
        offset = 0;
    }
    else
    {
        offset = fileSize - bufSize;
    }
    ret = ReadFile_NNsh(&fileRef, offset, bufSize, buffer, &readSize);
    CloseFile_NNsh(&fileRef);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {        
        NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh :",  FILE_RECVMSG, ret);
        goto USE_DEFAULT;
    }

    // p[^o
    MemSet(tempArea, areaSize, 0x00);
    ptr  = buffer;
    data = tempArea;
    while (ptr < (buffer + bufSize))
    {
        // 擪T
        ptr = StrStr(ptr, "<input type=hidden name=");
        if (ptr == NULL)
        {
            // p[^ȂA[v𔲂
            break;
        }
        ptr = ptr + StrLen("<input type=hidden name=");
        *data++ = '&';
        while ((*ptr != ' ')&&(*ptr != '>'))
        {
            *data++ = *ptr;
            ptr++;
        }
        // '=' o܂œǂݔ΂
        while ((*ptr != '=')&&(*ptr != '>'))
        {
            ptr++;
        }
        *data++ = *ptr;
        ptr++;

        //   value̐擪'"'(_uNI[e[V)ꍇ
        // p[^ƂĔFȂ({ɂȂŗǂ̂H)
        if (*ptr == '"')
        {
            do {
                *data ='\0';
                data--;
            } while (*data != '&');
            continue;
        }
        // 擾p[^lRs[
        while ((*ptr != ' ')&&(*ptr != '>'))
        {
            *data++ = *ptr;
            ptr++;
        }
    }
    *data = '\0';
    StrCat(tempArea, "&submit=");

    // submit{^̃o[擾
    ptr = StrStr(buffer, "<input type=submit value=");
    if (ptr == NULL)
    {
        //  p[^ȂAftHgsubmit{^̒l
        // Rs[ă[v𔲂
        StrCat(tempArea, defSubmit);
    }
    else
    {
        //////// submit{^̓e(URLGR[h)f //////
        // (datáARs[f[^̐擪 Aptr̓Rs[obt@)
        data = tempArea + StrLen(tempArea);
        ptr = ptr + StrLen("<input type=submit value=");
        if (*ptr == '"')
        {
            // _uNI[e[VȂP߂
            ptr++;
        }
        // 擾p[^lRs[
        while ((ptr < (buffer + bufSize))&&
               ((*ptr != ' ')&&(*ptr != '>')&&(*ptr != '"')))
        {
            if ((*ptr == '.')||(*ptr == '_')||
                (*ptr == '-')||(*ptr == '*')||
                ((*ptr >= '0')&&(*ptr <= '9'))||
                ((*ptr >= 'A')&&(*ptr <= 'Z'))||
                ((*ptr >= 'a')&&(*ptr <= 'z')))
            {
                //  ̂܂܃Rs[
                *data++ = *ptr;
                ptr++;
            }
            else
            {
                // URLGR[h(0x88 => '%88' ɕϊ)
                *data = '%';
                data++;
                *data = '\0';
                num = (UInt32) *ptr;
                MemSet(numBuf, sizeof(numBuf), 0x00);
                StrIToH(numBuf, num);

                // l̉Q~̂...
                StrCat(data, &numBuf[6]);
                data = data + 2; // 2 == StrLen(data);
                ptr++;
            }
        }
    }
    *data = '\0';

    NNsh_DebugMessage(ALTID_INFO, "Param :",  tempArea, 0);
    return;

USE_DEFAULT:
    // WBBSƎԂ擾
    MemSet(tempArea, areaSize, 0x00);
    setBBSNameAndTime(NNSH_BBSTYPE_2ch, nick, tempArea, areaSize);

    NNsh_DebugMessage(ALTID_INFO, "Param(Default):",  tempArea, 0);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : returnToMessageView                                        */
/*                                                          QƉʂɖ߂ */
/*-------------------------------------------------------------------------*/
static void returnToMessageView(void)
{
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(FRMID_MESSAGE);
    return;
}

/*=========================================================================*/
/*   Function : SaveWritingMessage                                         */
/*                                            ҏW̃bZ[Wۑ */
/*=========================================================================*/
void SaveWritingMessage(void)
{
    Err          ret;
    Char        *buffer;
    UInt32       writeSize;
    FormType    *frm;
    NNshFileRef  fileRef;

    // ꎞobt@̈m
    buffer = MemPtrNew(NNshParam->writeBufferSize + MARGIN);
    if (buffer == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MemPtrNew() ", " size:",
                          NNshParam->writeBufferSize + MARGIN);
        return;
    }
    MemSet(buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);

    // ҏWbZ[W擾
    frm = FrmGetActiveForm();
    NNshWinGetFieldText(frm,FLDID_WRITE_MESSAGE,buffer,NNshParam->writeBufferSize);
    if (StrLen(buffer) == 0)
    {
        // ҏWȂꍇ͏I
        MemPtrFree(buffer);
        return;
    }

    // ݉ʏIXŕۑOFF̂Ƃ
    if (NNshParam->writeMessageAutoSave == 0)
    {
        // ҏWۑ邩mF
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,MSG_CONFIRM_SAVEMSG, "", 0) != 0)
        {
            // Cancel{^ꂽAۑɏI
            MemPtrFree(buffer);
            return;
        }
    }

    // ҏW(PalmfoCX)t@C(write.txt)ɏ
    ret = OpenFile_NNsh(FILE_WRITEMSG,
                        (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
        goto FUNC_END;
    }
    ret = AppendFile_NNsh(&fileRef, StrLen(buffer), buffer, &writeSize);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", ret);
    }
    ret = CloseFile_NNsh (&fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CloseFile() ", " ret:", ret);
    }
    else
    {
        NNsh_DebugMessage(ALTID_INFO, "Save Message", " bytes:", writeSize);
    }

    // ҏW̖O(PalmfoCX)t@C(writeName.txt)ɏ
    MemSet(buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);

    // ҏWbZ[W擾
    frm = FrmGetActiveForm();
    NNshWinGetFieldText(frm, FLDID_WRITE_NAME, buffer, NNshParam->writeBufferSize);
    if (StrLen(buffer) == 0)
    {
        // ҏWȂꍇ͏I
        goto FUNC_END;

    }

    ret = OpenFile_NNsh(FILE_WRITENAME,
                        (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
        goto FUNC_END;
    }
    ret = AppendFile_NNsh(&fileRef, StrLen(buffer), buffer, &writeSize);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", ret);
    }
    ret = CloseFile_NNsh (&fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CloseFile() ", " ret:", ret);
    }
    else
    {
        NNsh_DebugMessage(ALTID_INFO, "Save Message", " bytes:", writeSize);
    }

    // ҏWMail(PalmfoCX)t@C(writeMail.txt)ɏ
    MemSet(buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);

    // ҏWbZ[W擾
    frm = FrmGetActiveForm();
    NNshWinGetFieldText(frm, FLDID_WRITE_EMAIL, buffer, NNshParam->writeBufferSize);
    if (StrLen(buffer) == 0)
    {
        // ҏWȂꍇ͏I
        goto FUNC_END;

    }
    ret = OpenFile_NNsh(FILE_WRITEMAIL,
                        (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
        goto FUNC_END;
    }
    ret = AppendFile_NNsh(&fileRef, StrLen(buffer), buffer, &writeSize);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", ret);
    }
    ret = CloseFile_NNsh (&fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CloseFile() ", " ret:", ret);
    }
    else
    {
        NNsh_DebugMessage(ALTID_INFO, "Save Message", " bytes:", writeSize);
    }

FUNC_END:
    MemPtrFree(buffer);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : menuEvt_WriteMessage                                       */
/*                                            j[Iꂽ̏ */
/*-------------------------------------------------------------------------*/
static Boolean menuEvt_WriteMessage(EventType *event)
{
    switch (event->data.menu.itemID)
    {
        // ؒf
      case MNUID_NET_DISCONN:
        NNshNet_LineHangup();
        break;

        // ݎw
      case MNUID_WRITE_START:
        if (threadWrite_Message() != errNone)
        {
            // ݎs(ڑs)A݉ʂɖ߂B
            return (false);
            break;
	}
        returnToMessageView();
        break;

        // ݒ~ ق(XQƉʂɖ߂)
      case MNUID_WRITE_ABORT:
        // ҏWbZ[WobNAbv
        SaveWritingMessage();
        returnToMessageView();
        break;

        // ҏWj[Q
      case MNUID_EDIT_UNDO:
      case MNUID_EDIT_CUT:
      case MNUID_EDIT_COPY:
      case MNUID_EDIT_PASTE:
      case MNUID_SELECT_ALL:
        (void) NNsh_MenuEvt_Edit(event);
        break;

      case MNUID_SHOW_DEVICEINFO:
        // o[W̕\
        ShowDeviceInfo_NNsh();
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : checkCheckBoxUpdate                                        */
/*                                  `FbN{bNXXVꂽƂ̏ */
/*-------------------------------------------------------------------------*/
static void checkCheckBoxUpdate(UInt16 chkId)
{
    Char         data[BUFSIZE];
    UInt16       fieldId, *chkBox;
    FormType    *frm;
    frm = FrmGetActiveForm();

    MemSet(data, BUFSIZE, 0x00);
    switch (chkId)
    {
      case CHKID_HANDLENAME:
        StrNCopy(data, NNshParam->handleName, BUFSIZE - 1);
        fieldId = FLDID_WRITE_NAME;
        chkBox  = &(NNshParam->useFixedHandle);
        break;

      case CHKID_SAGE:
      default:
        StrCopy(data, "sage");
        fieldId = FLDID_WRITE_EMAIL;
        chkBox  = &(NNshParam->writeAlwaysSage);
        break;
    }

    // `FbN{bNXɃ`FbNĂꍇ
    if (CtlGetValue(FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,chkId))) == 0)
    {
        // f[^NA
        MemSet(data, BUFSIZE, 0x00);
        *chkBox = 0;
    }
    else
    {
        // f[^ݒ
        *chkBox = 1;
    }
    NNshWinSetFieldText(frm, fieldId, true, data, BUFSIZE);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : selEvt_Control_WriteMessage                                */
/*                                               {^ꂽ̏  */
/*-------------------------------------------------------------------------*/
static Boolean selEvt_Control_WriteMessage(EventType *event)
{
    Err ret;
    switch (event->data.ctlSelect.controlID)
    {
        // ݃{^(݌AXQƉʂɖ߂)
      case BTNID_WRITE_MESSAGE:
        ret = threadWrite_Message();
        if (ret != errNone)
        {
            // ݎs(ڑs)A݉ʂɖ߂B
            return (false);
            break;
	}
        returnToMessageView();
        break;

        // Clear{^(ݗ̈NA)
      case BTNID_WRITEMSG_CLR:
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,MSG_CONFIRM_MSGCLEAR, "", 0) == 0)
        {
            NNshWinSetFieldText(FrmGetActiveForm(), FLDID_WRITE_MESSAGE,
                                true, "", NNshParam->writeBufferSize);
        }
        break;

        // Cancel{^ ق(XQƉʂɖ߂)
      case BTNID_WRITE_CANCEL:
        // ҏWbZ[WobNAbv
        SaveWritingMessage();
        returnToMessageView();
        break;

        // O/Email̃`FbNXVꂽƂ
      case CHKID_HANDLENAME:
      case CHKID_SAGE:
        checkCheckBoxUpdate(event->data.ctlSelect.controlID);
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : selectKeyDownEvent                                         */
/*                                                 L[ꂽ̏  */
/*                                (WOAVXgneẽWOǉ) */
/*-------------------------------------------------------------------------*/
static Boolean selEvt_KeyDown_WriteMessage(EventType *event)
{
    Err       err;
    FormType *frm;
    Boolean   ret = false;
    UInt16    keyCode;

    //tungsten T 5way navigator (281AӁI)
    keyCode = KeyConvertFiveWayToJogChara(event);
    switch (keyCode)
    {
      // uv(WO_C)̏
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
        NNshWinViewPageScroll(FLDID_WRITE_MESSAGE,
                              SCLID_WRITE_MESSAGE, 0, winDown); 
        ret = true;
        break;

      // uv(WO_C)̏
      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
        NNshWinViewPageScroll(FLDID_WRITE_MESSAGE,
                              SCLID_WRITE_MESSAGE, 0, winUp); 
        ret = true;
        break;

      // CLIECtrl+Enter  JogƂ
      case vchrJogPush:
        if (NNshParam->writeJogPushDisable != 0)
        {
            // ݎPUSH{^𖳌ONȂ疳ɂ
            break;
        }
        err = threadWrite_Message();
        if (err != errNone)
        {
            // ݎs(ڑs)A݉ʂɖ߂B
            break;
	}
        returnToMessageView();
        ret = true;
        break;
 
      // TabL[Ƃ̏
      case chrHorizontalTabulation:
        // tH[JXbZ[WɂĂ
        frm = FrmGetActiveForm();
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_WRITE_MESSAGE));
        ret = true;
        break;

      // ̑̃{^Q
      case vchrJogPushedUp:
      case vchrJogPushedDown:
      case chrLeftArrow:
      case chrRightArrow:
      case vchrJogBack:
      default:
        break;
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : sclRepEvt_WriteMessage                                     */
/*                                       XN[o[XVCxg̏  */
/*-------------------------------------------------------------------------*/
static Boolean sclRepEvt_WriteMessage(EventType *event)
{
    Int16   lines;

    lines = event->data.sclExit.newValue - event->data.sclExit.value;
    if (lines < 0)
    {
      (void) NNshWinViewPageScroll(FLDID_WRITE_MESSAGE, SCLID_WRITE_MESSAGE,
                                   -lines, winUp);
    }
    else if (lines > 0)
    {
      (void) NNshWinViewPageScroll(FLDID_WRITE_MESSAGE, SCLID_WRITE_MESSAGE,
                                   lines, winDown);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : fldChgEvt_WriteMessage                                     */
/*                                                     XN[o[XV  */
/*-------------------------------------------------------------------------*/
static Boolean fldChgEvt_WriteMessage(EventType *event)
{
    NNshWinViewUpdateScrollBar(FLDID_WRITE_MESSAGE, SCLID_WRITE_MESSAGE);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Hander_WriteMessage                                      */
/*                                                       Cxgnh  */
/*-------------------------------------------------------------------------*/
Boolean Handler_WriteMessage(EventType *event)
{
    Boolean   ret = false;
#ifdef USE_HANDERA
    FormType *frm;
#endif

    switch (event->eType)
    {
      case keyDownEvent:
        // L[
        return (selEvt_KeyDown_WriteMessage(event));
        break;

      case ctlSelectEvent:
        // {^
        return (selEvt_Control_WriteMessage(event));
        break;

      case fldChangedEvent:
        // tB[hɕ
        return (fldChgEvt_WriteMessage(event));
        break;

      case sclRepeatEvent:
        // XN[o[XV
        return (sclRepEvt_WriteMessage(event));
        break;

      case menuEvent:
        // j[I
        return (menuEvt_WriteMessage(event));
       break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent :
	if(NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
	    HandEraResizeForm(frm);
            FrmDrawForm(frm);
        }
	break;
#endif // #ifdef USE_HANDERA

      case fldHeightChangedEvent:
      case fldEnterEvent:
      case frmOpenEvent:
      case frmUpdateEvent:
      case popSelectEvent:
      case lstSelectEvent:
      case lstEnterEvent:
      case lstExitEvent:
      case sclExitEvent:
      default:
        break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function : OpenForm_WriteMessage                                      */
/*                                                    ݎw̏ */
/*=========================================================================*/
void OpenForm_WriteMessage(FormType *frm)
{
    Err                  ret, subRet, dbRet;
    Char                 msg[BUFSIZE], *buffer;
    Char                 title[NNSH_WRITELBL_MAX + 1];
    UInt32               fileSize, readSize;
    UInt16               alwaysSage, useFixedHandle, titleLen;
    NNshFileRef          fileRef;
    NNshSubjectDatabase  subjDB;
    FieldAttrType        attr;
    FieldType           *fldP;

    // tH[^Cg̐ݒ
    MemSet (title, sizeof(title), 0x00);
    StrCopy(title, NNSH_WRITELBL_HEAD);
    dbRet = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (dbRet == errNone)
    {
        // ݐXtH[^Cgɐݒ肷
        StrCat(title, ":");
        titleLen = (sizeof(NNSH_WRITELBL_HEAD)); // ":"ǉ̂sizeof()
        StrNCopy(&title[titleLen],
                 subjDB.threadTitle,
                 (NNSH_WRITELBL_MAX - titleLen));
    }
    FrmCopyTitle(frm, title);

    alwaysSage     = NNshParam->writeAlwaysSage;
    useFixedHandle = NNshParam->useFixedHandle;

    // `FbN{bNXݒ(nh)
    CtlSetValue(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm,CHKID_HANDLENAME)),
                useFixedHandle);

    // `FbN{bNXݒ(E-Mail)
    CtlSetValue(FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SAGE)),
                alwaysSage);

    // A_[C̕\ݒ
    MemSet(&attr, sizeof(FieldAttrType), 0x00);
    fldP  = FrmGetObjectPtr(frm, 
                            FrmGetObjectIndex(frm, FLDID_WRITE_MESSAGE));
    FldGetAttributes(fldP, &attr);
    if (NNshParam->disableUnderlineWrite != 0)
    {
        attr.underlined = noUnderline;
    }
    else
    {
        attr.underlined = grayUnderline;
    }
    FldSetAttributes(fldP, &attr);

    // FILE_WRITEMSG݂邩`FbN
    ret = OpenFile_NNsh(FILE_WRITEMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret == errNone)
    {
        // MbZ[WTCY擾
        GetFileSize_NNsh(&fileRef, &fileSize);
        if (fileSize != 0)
        {
            // ꎞobt@̈m
            buffer = MemPtrNew(NNshParam->writeBufferSize + MARGIN);
            if (buffer != NULL)
            {
                MemSet(buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);
                // t@Cf[^ǂݏo
                ret = ReadFile_NNsh(&fileRef, 0, NNshParam->writeBufferSize,
                                    buffer, &readSize);
                if ((ret == errNone)||(ret == fileErrEOF))
                {
                    NNshWinSetFieldText(frm, FLDID_WRITE_MESSAGE, true,
                                        buffer, NNshParam->writeBufferSize);
                    ret = errNone;
                }
                MemPtrFree(buffer);
            }
            else
            {
                NNsh_DebugMessage(ALTID_ERROR, "Memory Alloc. ", "", ret);
                ret = ~errNone;
            }
        }
        else
        {
            NNsh_DebugMessage(ALTID_ERROR, "file size is 0. ", "", ret);
            ret = ~errNone;
        }
        CloseFile_NNsh(&fileRef);

        ///// NAME𕜋
        MemSet(msg, sizeof(msg), 0x00);
        subRet = OpenFile_NNsh(FILE_WRITENAME,
                            (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                            &fileRef);
        if (subRet == errNone)
        {
            subRet = ReadFile_NNsh(&fileRef, 0, sizeof(msg), msg, &readSize);
            if ((subRet == errNone)||(subRet == fileErrEOF))
            {
                NNshWinSetFieldText(frm, FLDID_WRITE_NAME, true,
                                    msg, BUFSIZE);
            }
        }
        CloseFile_NNsh(&fileRef);

        ///// E-MAIL𕜋
        MemSet(msg, sizeof(msg), 0x00);
        subRet = OpenFile_NNsh(FILE_WRITEMAIL,
                               (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                               &fileRef);
        if (subRet == errNone)
        {
            subRet = ReadFile_NNsh(&fileRef, 0, sizeof(msg), msg, &readSize);
            if ((subRet == errNone)||(subRet == fileErrEOF))
            {
                NNshWinSetFieldText(frm, FLDID_WRITE_EMAIL, true,
                                    msg, BUFSIZE);
                alwaysSage = 0;
            }
        }
        CloseFile_NNsh(&fileRef);
    }
    // ۑĂt@C폜
    (void) DeleteFile_NNsh(FILE_WRITEMSG, NNSH_VFS_DISABLE);
    (void) DeleteFile_NNsh(FILE_WRITENAME,NNSH_VFS_DISABLE);
    (void) DeleteFile_NNsh(FILE_WRITEMAIL,NNSH_VFS_DISABLE);

    // XԍtB[h̐擪ɒǉB
    if ((ret != errNone)&&(NNshParam->insertReplyNum != 0)&&(dbRet == errNone))
    {
        MemSet(msg, sizeof(msg), 0x00);
        StrCopy(msg, ">>");
        NUMCATI(msg, subjDB.currentLoc);
        StrCat (msg, "\n");
        NNshWinSetFieldText(frm, FLDID_WRITE_MESSAGE,true, msg,
                            NNshParam->writeBufferSize);
    }

    // sage(p[^ݒ莞)
    if (alwaysSage != 0)
    { 
        NNshWinSetFieldText(frm, FLDID_WRITE_EMAIL, true,
                            "sage", BUFSIZE);
    }

    // Ren@\gp(p[^ݒ莞)
    if ((useFixedHandle != 0)&&(NNshParam->handleName[0] != '\0'))
    {
        NNshWinSetFieldText(frm, FLDID_WRITE_NAME, true, 
                            NNshParam->handleName,
                            BUFSIZE);
    }

    // XN[o[XV
    NNshWinViewUpdateScrollBar(FLDID_WRITE_MESSAGE, SCLID_WRITE_MESSAGE);

    // tH[JXbZ[WtB[hɐݒ(p[^ݒ肳ĂȂꍇ)
    if (NNshParam->notAutoFocus == 0)
    {
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_WRITE_MESSAGE));
    }

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkWriteReply                                          */
/*                                                                         */
/*             ݌̉mF(ݒvCookie or ݌ 𒊏o) */
/*-------------------------------------------------------------------------*/
static Char *checkWriteReply(Char *buffer, UInt32 bufSize, UInt32 command, UInt16 bbsType)
{
     NNshFileRef  fileRef;
     UInt32       readSize;
     Char         *start, *end, *ptr, *buf;
     Err          ret;

     // MbZ[WJāAT[ỏǂݏo
     MemSet(buffer, bufSize, 0x00);
     ret = OpenFile_NNsh(FILE_RECVMSG,
                         (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                         &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Open HTTP Reply Message ", "", ret);
        return (NULL);
    }
    (void) ReadFile_NNsh(&fileRef, 0, bufSize, buffer, &readSize);
    CloseFile_NNsh(&fileRef);

    if (command == NNSH_WRITECHK_REPLY)
    {
        // T[ỏɂāA^CĝݒoB(bH)
        ptr = buffer;
        start = StrStr(ptr, "<title>");
        if (start == NULL)
        {
            start = StrStr(ptr, "<TITLE>");
        }
        if (start != NULL)
        {
            start = start + StrLen("<TITLE>");
        }
        else
        {
            start = ptr;
        }
        end   = StrStr(start, "</title>");
        if (end == NULL)
        {
            end = StrStr(start, "</TITLE>");
        }
        if (end != NULL)
        {
            *end = '\0';
        }

        if ((bbsType == NNSH_BBSTYPE_SHITARABA)||
            (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
        {
            // EUCSJɕϊ
            buf = MemPtrNew((StrLen(start) + MARGIN) * 2);
	    if (buf != NULL)
            {
                MemSet(buf, ((StrLen(start) + MARGIN) * 2), 0x00);
                StrCopySJ(buf, start);
                StrCopy(start, buf);
            }
        }
        else
        {
            buf = NULL;
        }
        // ^CgG[ǂmF
        ptr = StrStr(start, NNSH_SYMBOL_WRITE_NG);
        if (ptr != NULL)
        {
            // G[ĂAڍ׏T({當擾)
            ptr = StrStr((end + 1), NNSH_SYMBOL_WRITE_NG);
            if (ptr != NULL)
            {
                // 镶̐擪ύX
                start = ptr;

                // ̍Ō擾
                end = StrStr(start, "</");
                if (end != NULL)
                {
                    *end = '\0';
                }

                if ((bbsType == NNSH_BBSTYPE_SHITARABA)||
                    (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
                {
                    // EUCSJɕϊ
                    if (buf != NULL)
                    {
                        MemPtrFree(buf);
                    }
                    buf = MemPtrNew((StrLen(start) + MARGIN) * 2);
                    if (buf != NULL)
                    {
                        MemSet(buf, ((StrLen(start) + MARGIN) * 2), 0x00);
                        StrCopySJ(buf, start);
                        StrCopy(start, buf);
                    }
                }
            }
        }
        if (buf != NULL)
        {
            MemPtrFree(buf);
        }
    }
    else
    {
        // ݎw CookiëʒuT
        ptr   = buffer;
        start = StrStr(ptr, "Set-Cookie: ");
        if (start == NULL)
        {
            return (NULL);
        }

        // ݎwCookie̍ŌT
        end = start;
        while ((end <= start + bufSize)&&(*end != ';'))
        {
            end++;
        }
        *end = '\0';
        NNsh_DebugMessage(ALTID_INFO, MSG_RECV_SERVERRESPONSE, start, 0);
    }
    return (start);
}

/*-------------------------------------------------------------------------*/
/*   Function : threadWrite_Message                                        */
/*                                                           ݏ  */
/*-------------------------------------------------------------------------*/
static Err threadWrite_Message(void)
{
    UInt16               index, subBufSize;
    NNshSubjectDatabase  subjDB;
    NNshBoardDatabase    bbsData;
    Err                  ret;
    Char                *subBuf, msgID[MAX_THREADFILENAME];
    Char                 spId[BUFSIZE], param[BUFSIZE + BUFSIZE];
    Char                *url, *buffer, *ptr, *start;
    FormType            *frm;

    // (Tu)e|̈m
    subBufSize = 3 * BIGBUF;
    subBuf = MemPtrNew(subBufSize + MARGIN);
    if (subBuf == NULL)
    {
        NNsh_InformMessage(ALTID_ERROR, "SUB AREA MemPtrNew()",
                           " size:", subBufSize + MARGIN);
        return (~errNone);
    }

    // bZ[Wf[^x[X擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_INFO, "get_subject_database()", "", ret);
        goto FUNC_END;
    }

    // BBSf[^x[X擾
    ret = Get_BBS_Database(subjDB.boardNick, &bbsData, &index);

    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "Get_BBS_Database() nick:", 
                          subjDB.boardNick, ret);
        goto FUNC_END;
    }

    // ݂邩mF郁bZ[W
    if (NNsh_ConfirmMessage(ALTID_CONFIRM,MSG_CONFIRM_WRITEMSG,
                            subjDB.threadTitle, 0) != 0)
    {
        ret = ~errNone;
        goto FUNC_END;
    }

    // f[^Mp[Nobt@̊l
    buffer = (Char *) MemPtrNew(NNshParam->writeBufferSize + MARGIN);
    if (buffer == NULL)
    {
        // ̈̊mێsI
        NNsh_InformMessage(ALTID_ERROR, "SEND AREA MemPtrNew()",
                           " size:", NNshParam->writeBufferSize + MARGIN);
        goto FUNC_END;
    }
    MemSet (buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);
    MemSet (subBuf, (subBufSize + MARGIN), 0x00);
    StrCopy(subBuf, subjDB.boardNick);
    subBuf[StrLen(subjDB.boardNick) - 1] = '\0';

    MemSet (msgID, sizeof(msgID), 0x00);
    StrCopy(msgID, subjDB.threadFileName);
    ptr = StrStr (msgID, ".");
    if (ptr != NULL)
    {
        *ptr = '\0';
    }

    // M郁bZ[Wsend.txt֏o͂
    frm = FrmGetActiveForm();
    create_outputMessageFile(frm, buffer,
                             (NNshParam->writeBufferSize + MARGIN),
                             subBuf, msgID, (UInt16) subjDB.bbsType);

    //@MURL(Ƃ胊t@)Ǝ̍쐬
    MemSet(subBuf, (subBufSize + MARGIN), 0x00);
    MemSet(spId,   sizeof(spId),   0x00);
    url = spId;
    StrCopy(url, bbsData.boardURL);
    switch (subjDB.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // ܂BBS̏ꍇ
        StrCat(url, URL_PREFIX_MACHIBBS);
        StrCat(url, bbsData.boardNick);
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        }
        StrCat(url, "&KEY=");
        StrCat(url, msgID); 

        // BBSƌݎA{^̏o
        setBBSNameAndTime(subjDB.bbsType,bbsData.boardNick,subBuf,subBufSize);
        StrCat(subBuf, "&submit=%8F%91%82%AB%8D%9E%82%DE");
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS:
        // ΁iaar̂Ƃ 
        StrCat (url, URL_PREFIX_SHITARABAJBBS);
        StrCat (url, bbsData.boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&KEY=");
        StrCat (url, msgID); 

        // BBSƌݎA{^̏o
        setBBSNameAndTime(subjDB.bbsType,bbsData.boardNick,subBuf,subBufSize);
        StrCat(subBuf, "&submit=\x22\xbd\xf1\xa4\xad\xb9\xfe\xa4\xe0\x22");
        break;


      case NNSH_BBSTYPE_SHITARABA:
        // ΂̂Ƃ 
        StrCopy(url, "http://www.shitaraba.com/");
        StrCat (url, URL_PREFIX_SHITARABA);
        StrCat (url, bbsData.boardNick);
        //  '/' ĂOB
        if (buffer[StrLen(url) - 1] == '/')
        {
            buffer[StrLen(url) - 1] = '\0';
        }
        StrCat (url, "&key=");
        StrCat (url, msgID);

        // BBSA{^̏o(Ȃ񂩕...)
        MemSet(subBuf, subBufSize, 0x00);
        StrCat (subBuf, "&bbs=");
        StrCat (subBuf, bbsData.boardNick);
        //  '/' ĂOB
        if (subBuf[StrLen(subBuf) - 1] == '/')
        {
            subBuf[StrLen(subBuf) - 1] = '\0';
        }
        StrCat(subBuf, "&submit=%A4%AB%A4%AD%A4%B3%A4%81");
        break;

      case NNSH_BBSTYPE_2ch:
      default:
        // 2ch̏ꍇ
        StrCopy(&url[StrLen(url) - StrLen(bbsData.boardNick)],  URL_PREFIX);
        StrCat (url, bbsData.boardNick);
        StrCat (url, msgID);
        StrCat (url,  "/");

        // MV[PXQ̂ƂAtH[̃p[^x擾ǉB
        if (NNshParam->writeSequence2 != 0)
        {
            // ݃tH[擾
            MemSet (param, sizeof(param), 0x00);
            StrCopy(param, url);
            StrCat (param, "1n");
            NNsh_DebugMessage  (ALTID_INFO, "Get Param. (URL)", param, 0);
            ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, param,
                                NULL, NULL, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT,
                                NULL);
            if (ret != errNone)
            {
                // (^CAEgȊO)ʐMG[
                if (ret != netErrTimeout)
                {
                    NNsh_InformMessage(ALTID_ERROR,
                                       MSG_ERROR_HTTP_COMM, "[FORM]", ret);
                }
                else
                {
                    // ʐM^CAEg
                    NNsh_InformMessage(ALTID_ERROR,
                                       MSG_OCCUR_TIMEOUT, "[FORM]", ret);
                }
            }

            // MtH[Ap[^؂o
            setFormParameters(bbsData.boardNick,
                              buffer, NNshParam->writeBufferSize,
                              subBuf, subBufSize, "%8F%91%82%AB%8D%9E%82%DE");
        }
        else
        {
            // BBSƌݎA{^̏o
            setBBSNameAndTime(subjDB.bbsType, bbsData.boardNick,
                              subBuf, subBufSize);
            StrCat(subBuf, "&submit=%8F%91%82%AB%8D%9E%82%DE");
        }
        break;
    }
    MemPtrFree(buffer);

    // ݃V[PX^CvQ̂Ƃ́AƑҋ@
    if (NNshParam->writeSequence2 != 0)
    {
        // uҋ@v\
        Show_BusyForm(MSG_INFO_WRITEWAIT);

        SysTaskDelay(NNSH_WRITE_DELAYTIME * SysTicksPerSecond());

        Hide_BusyForm(false);
    }

    // bZ[W𑗐M
    NNsh_DebugMessage(ALTID_INFO, "Send(1) ", url, 0);
    NNsh_DebugMessage(ALTID_INFO, "Param:  ", subBuf, 0);
    switch (subjDB.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        ret = NNshHttp_comm(HTTP_SENDTYPE_POST_MACHIBBS, url,
                            NULL, subBuf, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT,
                            NULL);
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS:
        ret = NNshHttp_comm(HTTP_SENDTYPE_POST_SHITARABAJBBS, url,
                            NULL, subBuf, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT,
                            NULL);
        break;

      case NNSH_BBSTYPE_SHITARABA:
        ret = NNshHttp_comm(HTTP_SENDTYPE_POST_SHITARABA, url,
                            NULL, subBuf, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT,
                            NULL);
        break;

      case NNSH_BBSTYPE_2ch:
      default:
        ret = NNshHttp_comm(HTTP_SENDTYPE_POST, url,
                            NULL, subBuf, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT,
                            NULL);
        break;
    }
    if (ret != errNone)
    {
        if (ret != netErrTimeout)
        {
            // (^CAEgȊO)ʐMG[
            NNsh_InformMessage(ALTID_ERROR,
                               MSG_ERROR_HTTP_COMM, "(pre-Write)", ret);
        }
        else
        {
            // ^CAEg
            NNsh_InformMessage(ALTID_ERROR,
                               MSG_OCCUR_TIMEOUT, "(pre-Write)", ret);
        }
        goto FUNC_END;
    }

    /////////////////////////////////////////////////////////////////////////
    //   MCookiegpď݂sȂꍇA܂zXg
    // u݂܂BvƉꍇɂ́ACookiegp݂
    // sȂ悤ɂ
    // (܂BBS̏ꍇCookiegp݂̏sȂ悤ɂ)
    /////////////////////////////////////////////////////////////////////////

    // T[ỏ
    MemSet(subBuf, subBufSize + MARGIN, 0x00);
    start = checkWriteReply(subBuf, subBufSize, NNSH_WRITECHK_REPLY, subjDB.bbsType);
    if ((NNshParam->useCookieWrite == 0)||
        (subjDB.bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (subjDB.bbsType == NNSH_BBSTYPE_SHITARABA)||
        (subjDB.bbsType == NNSH_BBSTYPE_SHITARABAJBBS)||
        (StrCompare(start, NNSH_SYMBOL_WRITE_DONE) == 0))
    {
        // XbZ[W̍đM͍sȂA擾`FbN
        goto WRITE_NEXT;
    }

    // Cookiegpď݃bZ[WđM

    // f[^͗p̃obt@mۂ
    buffer = (Char *) MemPtrNew(NNshParam->writeBufferSize + MARGIN);
    if (buffer == NULL)
    {
        // ̈̊mێsI
        NNsh_InformMessage(ALTID_ERROR, "ANALYSIS AREA MemPtrNew()",
                           " size:", NNshParam->writeBufferSize + MARGIN);
        ret = ~errNone;
        goto FUNC_END;
    }

    // łtH[̃p[^f[^擾
    MemSet (buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);
    MemSet (param, sizeof(param), 0x00);
    setFormParameters(bbsData.boardNick, buffer, NNshParam->writeBufferSize,
                      param,  sizeof(param),
                      "%91S%90%D3%94C%82%F0%95"
                      "%89%82%A4%82%B1%82%C6%82%F0%8F%B3"
                      "%91%F8%82%B5%82%C4%8F%91%82%AB%8D"
                      "%9E%82%DE");

    // T[ỏ́ASPID擾
    MemSet (buffer, (NNshParam->writeBufferSize + MARGIN), 0x00);
    ptr =
         checkWriteReply(buffer,NNshParam->writeBufferSize,NNSH_WRITECHK_SPID, subjDB.bbsType);
    if (ptr == NULL)
    {
        // T[ỏُ킾
        NNsh_ErrorMessage(ALTID_ERROR, MSG_WRITEREPLY_WRONG, url, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // SPID擾
    MemSet(spId, sizeof(spId), 0x00);
    StrNCopy(spId, ptr, sizeof(spId) - 1);

    // ͂̈J
    MEMFREE_PTR(buffer);

    //@MURL̍쐬
    MemSet(subBuf, subBufSize + MARGIN, 0x00);
    url = subBuf;
    StrCopy(url, bbsData.boardURL);
    StrCopy(&url[StrLen(url) - StrLen(bbsData.boardNick)],  URL_PREFIX);
    StrCat (url, bbsData.boardNick);
    StrCat (url, msgID);
    StrCat (url,  "/");

    // (parametercookieĐݒ肵)bZ[W𑗐M
    NNsh_DebugMessage(ALTID_INFO, "Send(2) ", url, 0);
    ret = NNshHttp_comm(HTTP_SENDTYPE_POST, url, spId, param, 
                        HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,
                               MSG_ERROR_HTTP_COMM, "(Write)", ret);
        }
        else
        {
            NNsh_InformMessage(ALTID_ERROR,
                               MSG_OCCUR_TIMEOUT, "(Write)", ret);
        }
        goto FUNC_END;
    }

    // T[ỏ
    MemSet(subBuf, (subBufSize + MARGIN), 0x00);
    start = checkWriteReply(subBuf, subBufSize, NNSH_WRITECHK_REPLY, subjDB.bbsType);

WRITE_NEXT:

#if 0
    // ͂̌ʂ\
    NNsh_InformMessage(ALTID_INFO, MSG_RECV_SERVERRESPONSE, start, 0);
#endif

    // ݐ悪擾ł邩ǂ`FbN
    MemSet (url, sizeof(url), 0x00);
    switch (subjDB.bbsType)
    {
      case NNSH_BBSTYPE_SHITARABAJBBS:
      case NNSH_BBSTYPE_MACHIBBS:
        //  ܂BBS/΁JBBSɏ񂾂Ƃ́AX擾
        // łȂ̂łŐ܂ԂB
        NNsh_InformMessage(ALTID_INFO, MSG_NOTSUPPORT_MACHI2, "", 0);
        ret = errNone;
        goto FUNC_END;
        break;

      case NNSH_BBSTYPE_SHITARABA:
        // 
        StrCopy(url, bbsData.boardURL);
        StrCat (url, "bbs/");
        StrCat (url, subjDB.boardNick);
        StrCat (url, "dat/");
        StrCat (url, subjDB.threadFileName);
        break;

      case NNSH_BBSTYPE_2ch:
      default:
        // 2˂
        StrCopy(url, bbsData.boardURL);
        StrCat (url, "dat/");
        StrCat (url, subjDB.threadFileName);

        // ͂̌ʂ\
        NNsh_InformMessage(ALTID_INFO, MSG_RECV_SERVERRESPONSE, start, 0);
        if (StrCompare(start, NNSH_SYMBOL_WRITE_DONE) != 0)
        {
            // G[߁A݉ʂ͔Ȃ(͎擾)
            ret = ~errNone;
            // goto FUNC_END;
        }
        break;
    }

    // X擾s
    (void) Get_PartMessage(url, bbsData.boardNick, &subjDB, 
                           NNshParam->openMsgIndex, NULL);

FUNC_END:
    MEMFREE_PTR(subBuf);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : create_outputMessageFile                                   */
/*                                                ݃bZ[W̏o */
/*-------------------------------------------------------------------------*/
static Err create_outputMessageFile(FormType *diagFrm, Char *buffer,
                                    UInt32 bufSize, Char *boardNick, 
                                    Char *key, UInt16 bbsType)
{
    Err          ret;
    Char        *ptr;
    UInt32       dummy;
    NNshFileRef  sendRef;

    // o͗pt@C̏
    (void) DeleteFile_NNsh(FILE_SENDMSG, NNSH_VFS_DISABLE);
    ret = OpenFile_NNsh(FILE_SENDMSG, 
                        (NNSH_FILEMODE_APPEND|NNSH_FILEMODE_TEMPFILE),
                        &sendRef);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, "OpenFile_NNsh() ", FILE_SENDMSG, ret);
        return (ret);
    }

    // key̏o
    MemSet (buffer, bufSize, 0x00);
    if ((bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        StrCopy(buffer, "KEY=");
    }
    else
    {
        StrCopy(buffer, "key=");
    }
    StrCat (buffer, key);

    // Ȍo
    if ((bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        StrCat (buffer, "&NAME=");
    }
    else
    {
        StrCat (buffer, "&FROM=");
    }
    ptr = buffer;
    (void) AppendFile_NNsh(&sendRef, StrLen(ptr), ptr, &dummy);
    outputTextField(diagFrm, FLDID_WRITE_NAME, buffer, bufSize, bbsType, &sendRef);

    // E-Mail̏o
    if ((bbsType == NNSH_BBSTYPE_MACHIBBS)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        ptr = "&MAIL=";
    }
    else
    {
        ptr = "&mail=";
    }
    (void) AppendFile_NNsh(&sendRef, StrLen(ptr), ptr, &dummy);
    outputTextField(diagFrm, FLDID_WRITE_EMAIL, buffer, bufSize, bbsType, &sendRef);

    // bZ[W̏o
    ptr = "&MESSAGE=";
    (void) AppendFile_NNsh(&sendRef, StrLen(ptr), ptr, &dummy);
    outputTextField(diagFrm, FLDID_WRITE_MESSAGE, buffer, bufSize, bbsType, &sendRef);

    // t@CN[Y
    CloseFile_NNsh(&sendRef);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function : outputTextField                                            */
/*                                                      eLXg̈̏o */
/*-------------------------------------------------------------------------*/
static void outputTextField(FormType *frm, UInt16 fldID, Char *buf, UInt16 size, UInt16 bbsType, NNshFileRef *fileRef)
{
    Char   *dat;
    UInt32  dum;
    UInt16  len;

    NNshWinGetFieldText(frm, fldID, buf, size);
    len = StrLen(buf);
    if (len == 0)
    {
      // lLĂȂ
        return;
    }

    if ((bbsType == NNSH_BBSTYPE_SHITARABA)||
        (bbsType == NNSH_BBSTYPE_SHITARABAJBBS))
    {
        // ΁A΁iaar̂Ƃ͊R[hϊ
        dat = MemPtrNew(len * 2);
        if (dat == NULL)
        {
            // ̈mۂɎŝŁÂ܂܏o
            (void) AppendFileAsURLEncode_NNsh(fileRef, len, buf, &dum);
        }
        else
        {
            // EUCR[hɕϊďo
            MemSet(dat, (len * 2), 0x00);
            StrCopyEUC(dat, buf);
            (void) AppendFileAsURLEncode_NNsh(fileRef, StrLen(dat), dat, &dum);
                                                  
            MemPtrFree(dat);
        }
    }
    else
    {
        // ̂܂܏o
        (void) AppendFileAsURLEncode_NNsh(fileRef, len, buf, &dum);
    }
    return;
}
