import os
import sys

from distutils.core import setup

# Create mo files:
if not os.path.exists('mo/'):
    os.mkdir('mo/')
python_path = sys.prefix
py_path = os.path.abspath(os.path.join(python_path, 'python.exe'))
msgfmt_path = os.path.abspath(os.path.join(python_path, 'Tools/i18n/msgfmt.py'))
langs = (l[:-3] for l in os.listdir('locale') if l.endswith('.po'))
for lang in langs:
    pofile = os.path.join('locale', '{0}.po'.format(lang))
    modir = os.path.join('mo', lang)
    mofile = os.path.join(modir, 'ninix.mo')
    if not os.path.exists(modir):
        os.mkdir(modir)
    print('generating', mofile)
    os.system('{0} {1} -o {2} {3}'.format(py_path, msgfmt_path, mofile, pofile))

setup(
    name = 'ninix-aya',
    version = '4.99.8',
    package_dir = {'': 'lib'},
    packages=['ninix', 'ninix.dll'],
    scripts = ['lib/ninix_main.py', 'ninix_win32_postinst.py'],
    data_files = [('share/locale/ja/LC_MESSAGES', ['mo/ja/ninix.mo']),
                  ('share/locale/zh_TW/LC_MESSAGES', ['mo/zh_TW/ninix.mo']),],
    options = {'bdist_wininst': {'install_script': 'ninix_win32_postinst.py'}}
)
