﻿////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
//	danmaq Nineball-Library
//		Copyright (c) 2008-2011 danmaq all rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

using System;
using Microsoft.Xna.Framework.Content;

namespace danmaq.nineball.data.content
{

	//* ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ *
	/// <summary>コンテンツ キャッシュのインターフェイス。</summary>
	/// <remarks>
	/// コンテンツ キャッシュにコンテンツ マネージャを設定するためだけに使用します。
	/// </remarks>
	public interface ICache : IDisposable
	{

		//* ─────-＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿*
		//* properties ──────────────────────────────*

		//* -----------------------------------------------------------------------*
		/// <summary>コンテンツ マネージャを設定/取得します。</summary>
		/// 
		/// <value>コンテンツ マネージャ オブジェクト。</value>
		ContentManager mgrContent
		{
			get;
			set;
		}

		//* -----------------------------------------------------------------------*
		/// <summary>読み出し対象のアセット文字列を取得します。</summary>
		/// 
		/// <value>読み出し対象のアセット文字列。</value>
		string asset
		{
			get;
		}

		//* ────＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿_*
		//* methods ───────────────────────────────-*

		//* -----------------------------------------------------------------------*
		/// <summary>コンテンツを読み込みます。</summary>
		void preload();
	}
}
