# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: test_interceptor.rb,v 1.1 2003/12/26 03:02:26 takai Exp $

require 'rubyunit'
require 'tudura/interceptor'

include Tudura

class Calc
  def plus a, b
    a + b
  end
  def minus a, b
    a - b
  end
end

class CalcInterceptor
  include Interceptor
  def intercept name, args, chain
    if name == :plus
      args = [1, 1]
    end
    chain.proceed name, args
  end
end

class InterceptorProxyTest < RUNIT::TestCase
  def setup
    @calc = InterceptorProxy.new
  end
  def test_proceed1
    @calc.interceptors = [Calc.new]
    assert_equals 3, @calc.plus(1, 2)
  end
  def test_proceed2
    @calc.interceptors = [CalcInterceptor.new, Calc.new]
    assert_equals 2, @calc.plus(1, 2)
  end
  def test_proceed3
    @calc.interceptors = [CalcInterceptor.new, Calc.new]
    assert_equals 1, @calc.minus(2, 1)
  end
end
