# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: web.rb,v 1.1 2003/12/27 06:50:38 takai Exp $

require 'webrick/cgi'
require 'erb'

module Tudura
  module Handler
    include Tudura::ContextAware
    
    attr_writer :logger
        
    def handle_request req, res
      view_name, model = handle req, res
      view(view_name).render model, req, res
    end
    def resolver
      @context.fetch :view_resolver
    end
    def view view_name
      resolver.resolv_name view_name
    end
  end

  class ErbView
    attr_accessor :content_type, :charset
    attr_accessor :resource

    def initialize
      self.content_type = 'text/html'
      self.charset = 'UTF-8'
    end
    def render model, req, res
      erb = ERB.new template
      bind = make_binding model

      res['content-type'] = "#{self.content_type}; charset=#{self.charset}"
      res.body = erb.result bind
    end
    def template
      File.open(resource){|f| f.read}
    end
    def empty_binding
      binding
    end
    def make_binding(params)
      keys = params.keys
      vals = keys.map {|k| params[k]}
      eval("lambda {|#{params.keys.join(",")}| binding}",
           empty_binding).call(*vals)
    end
  end

  class FilenameViewResolver
    attr_accessor :mappings, :prefix, :suffix
    
    def initialize
      self.mappings = {}
      self.prefix   = ""
      self.suffix   = ""
    end
    
    def resolv_name view_name
      view = mappings[view_name]
      view.resource = prefix + view_name + suffix
      view
    end
  end

  class PathInfoHandlerMapping
    attr_accessor :default_handler, :mappings
    
    public
    def get_handler req
      handler_name = get_handler_name req.path_info
      mappings[handler_name] || mappings[default_handler]
    end
    
    private
    def get_handler_name path_info
      path_info ||= '/'

      handler_name = path_info.split("/", 3)[1]
      handler_name ||= ''
      handler_name = default_handler if handler_name.empty?
      handler_name
    end
  end

  class DispatcherServlet < WEBrick::CGI
    
    attr_accessor :handler_mapping

    def initialize
      super
      @logger = WEBrick::BasicLog.new
    end

    def do_service req, res
      handler = handler_mapping.get_handler req
      handler.logger = @logger
      handler.handle_request req, res
    end

    def do_GET req, res
      do_service req, res
    end

    def do_POST req, res
      do_service req, res
    end

    def do_HEAD req, res
      do_service req, res
    end
  end
end
