# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: tudura.rb,v 1.2 2003/12/26 15:22:27 takai Exp $

require 'ostruct'
require 'tudura/config'

module Tudura
  
  class Context
    attr_accessor :defs
    def initialize(&block)
      @space     = {}
      self.defs  = []
      ReferenceValue.context = self

      if block_given?
	block.call self.defs
      end
    end
    def configure
      self.instatiate
      self.setup
      self
    end
    def instatiate
      defs.each do |d|
	obj = d.instatiate
	if obj.is_a? ContextAware
	  obj.context = self
	end
	@space[d.key] = obj
      end
    end
    def setup
      defs.each do |d| d.setup @space[d.key] end
    end
    def fetch key
      @space.fetch key
    end
  end

  module ContextAware
    attr_writer :context
  end

end
