# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: simple.rb,v 1.1 2003/12/27 06:57:59 takai Exp $

require 'tudura'
require 'tudura/xmlconfig'

context = Tudura::XMLContext.new(DATA.read).configure

open_struct = context.fetch(:struct)

p open_struct.class    # => OpenStruct
p open_struct.integer  # => 100
p open_struct.float    # => 10.0
p open_struct.string   # => "string"
p open_struct.array    # => [0, 1, 2]
p open_struct.hash_val # => {"a"=>"a", "b"=>"b"}

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="struct">
    <property name="integer"><value>100</value></property>
    <property name="float"><value>10.0</value></property>
    <property name="string"><value>string</value></property>
    <property name="array">
      <array>
        <value>0</value>
        <value>1</value>
        <value>2</value>
      </array>
    </property>
    <property name="hash_val">
      <hash>
        <entry key="a"><value>a</value></entry>
        <entry key="b"><value>b</value></entry>
      </hash>
    </property>
  </object>
</context>
