#! /usr/bin/env ruby
# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: hello_webapp.rb,v 1.1 2003/12/27 06:50:38 takai Exp $

require 'tudura'
require 'tudura/web'
require 'tudura/xmlconfig'

class MyErbView < Tudura::ErbView
  def template
    <<-EOF
<html>
<head>
<title>Hello Application</title>
<head>
<body>
<p>Hello, <%= name %>!</p>
<form method="post">
your name: <input type="text" name="name">
</form>
</body>
</html>
    EOF
  end
end

class HelloHandler
  include Tudura::Handler
  
  def handle req, res
    name = req.query['name'] || 'World'
    ['hello', {'name' => name}]
  end
end

context = Tudura::XMLContext.new(DATA.read).configure
servlet = context.fetch :servlet
servlet.start

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="servlet" class="Tudura::DispatcherServlet">
    <property name="handler_mapping">
      <ref object="handler_mapping" />
    </property>
  </object>
  <object id="handler_mapping" class="Tudura::PathInfoHandlerMapping">
    <property name="default_handler"><value>hello</value></property>
    <property name="mappings">
      <hash>
        <entry key="hello"><ref object="hello_handler" /></entry>
      </hash>
    </property>
  </object>
  <object id="hello_handler" class="HelloHandler" />
  <object id="view_resolver" class="Tudura::FilenameViewResolver">
    <property name="mappings">
      <hash>
        <entry key="hello"><ref object="erb" /></entry>
      </hash>
    </property>
  </object>
  <object id="erb" class="MyErbView" />
</context>
