# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: hello.rb,v 1.1.1.1 2003/12/25 11:30:13 takai Exp $

require 'tudura'
require 'tudura/xmlconfig'

class Person
  attr_accessor :name
  def introduce
    "Hello, My name is #{name}."
  end
end

context = Tudura::XMLContext.new(DATA.read).configure
alice = context.fetch :alice
bob   = context.fetch :bob

puts alice.introduce # => "My name is Alice."
puts bob.introduce   # => "My name is Bob."

__END__
<?xml version="1.0" encoding="UTF-8" ?>

<context>
  <object id="alice" class="Person">
    <property name="name"><value>Alice</value></property>
  </object>
  <object id="bob" class="Person">
    <property name="name"><value>Bob</value></property>
  </object>
</context>
