// MMCBoot for EDU1(ATmega168)
// LED gamepMMCBootEDU1pɉ܂ by takuyamatsubara

// J[hoCi(bin)t@Cǂݍ
// }CR̃tbVɏ݂܂B
// tbV̑O12KBvOpɊU܂B
// tbV̌㔼4KBu[g[_[ɊU܂B

// IWił͂
// http://yuki-lab.jp/hw/MMCboot/index.html 

//******************************************************************
//
//	MMC File Select and Bootloader for "LED Game for AVR"
//
//	MCU:ATmega168
//		efuse:0xF8	u[g̈ 1024word ZbgxN^̓u[g̈
//		hfuse:0xD5	`bv EEPROMی, BOD 2.7V
//		lfuse:0xE2	CR 8MHz
//
//	Compiler:	AVR-GCC		3.4.6
//				AVR-LIBC	1.4.4
//				binutils	2.16.1
//
//	2007.2.4	KAWAKAMI Yukio
//	2007.2.8	J[h CS̃|[g PC3ɕύX
//	2007.2.9	t@Cԍhbg̈ʒuŕ\
//	2007.2.15	MMCǂݍ݃[`œKEt@CpJiΉ
//
//	New BSD license
//******************************************************************

#include	<avr/io.h>
#include	<avr/interrupt.h>
#include	<avr/pgmspace.h>
#include	<avr/boot.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"sfont.h"

#include	"MMCboot.h"

uchar	DiskCache[512];	// fBXNLbV
//ulong	DiskCacheAddr;

uchar	FATtype;			// 1:FAT12  2:FAT16
uchar	SectorsPerCluster;	// 1NX^̃ZN^
ushort	ReservedSectors;	// \ZN^
uchar	FATcount;			// FAT̐ ʏ 2
uint	RootDirEntriesCount;	// [gfBNgGg[
ulong	SectorCount;	// ZN^
ushort	FATsectors;		// FATggZN^
uint	FATstart;		// FATJnZN^
uint	DIRstart;		// [gfBNgJnZN^
ulong	DataStart;		// f[^̈JnZN^
//ushort	ClusterCount;	// NX^

#define LEDWIDTH 32		// LEDhbg
#define LEDHEIGHT 16		// LEDhbg

unsigned long ledvram[LEDHEIGHT];	 // LED Bitmap Buffer(VRAM)
char row=0;
char lrflag=0;	// left /right

#define LED_CLKPORT  PORTB // LEDp|[g
#define LED_CLKDDR   DDRB  // LEDp|[go
#define LED_CLK      0     // NbNrbgԍ

#define LED_DATPORT  PORTD // LEDp|[g
#define LED_DATDDR   DDRD  // LEDp|[go
#define LED_DATA     6     // f[^rbgԍ

#define LED_LCHPORT  PORTC // LEDp|[g
#define LED_LCHDDR   DDRC  // LEDp|[go
#define LED_LATCH    0     // b`rbgԍ

void led_sendword(unsigned int dat);
void led_drive(void);

ushort	NextData;

#define SW_D		0x80
#define SW_C		0x40
#define SW_B		0x20
#define SW_A		0x10
#define SW_RIGHT	0x08
#define SW_LEFT		0x04
#define SW_DOWN		0x02
#define SW_UP		0x01


char text_x=0;
//char text_y=0;
volatile unsigned char swdata;

//****************************************************************************
// 0x0000-0x2FFF       app
//---------------------------------------
// 0x3000(0x1800w) app2 (bootloader) 1024w
// 0x3800(0x1C00w) boot (bootloader) 1024w
//****************************************************************************

void BOOTLOADER_SECTION start_loader(void)
{
	asm volatile("jmp	__init\n"::);	//jump to main()

}

void BOOTLOADER_SECTION printerr(char *errstr)
{
	cls();
	print(errstr);
	print("Err");

	getkey();
}

/*
void BOOTLOADER_SECTION printhex(unsigned char num)
{
	char i=32;
	char numh;

	numh = num >> 4;
	num += '0';
	if(numh > '9')
		numh+= (('A'-'0')-10);

	num &= 0xf;
	num += '0';
	if(num > '9')
		num+= (('A'-'0')-10);

	led_putch(numh);
	led_putch(num);

	while(i--){
		led_drive();
	}
}
*/

//****************************************************************
// ZtvO~OEC
//
//	̒ŃvȌŝŁA
//	K AVR̃u[g[_̈ɔzu邱
//****************************************************************
uchar BOOTLOADER_SECTION spm_main(struct FILE_DATA *fd){
	uint	i;
	ushort	w;
	ushort	sum;
	ulong	page;

	page = 0;
	sum = 0;

	cli();

	while(page < fd->size){
		// MMC/SDPZN^ǂݍ
		if (mmc_read(fd->sec)){
			printerr("Read");
			return 1;
		}
		for (i = 0; i < 512; i += 2){
			if ((i & (SPM_PAGESIZE - 1)) == 0){
				// y[W
//				eeprom_busy_wait ();
				boot_page_erase(page);
				boot_spm_busy_wait();
				sum = 0xFFFF;
			}
//			printhex(DiskCache[i  ]);	//debug
//			printhex(DiskCache[i+1]);	//debug

			w = *(ushort *)(&DiskCache[i]);
			sum &= w;
			boot_page_fill(page + i, w);
			if ((i & (SPM_PAGESIZE - 1)) == (SPM_PAGESIZE - 2)){
				if (sum != 0xFFFF){	// S FFFF Ȃ珑܂Ȃ
					// y[W
					boot_page_write(page);
					boot_spm_busy_wait();
				}
				page += SPM_PAGESIZE;
			}
		}
		next_sector(fd);
	}

	// RWWZNVLɂ
	boot_rww_enable();

	// 0ԒnɃWv(RESET)
//	asm volatile("jmp	0\n"::);

	return 0;
}


//**********************************************
//	[U[AvP[VsJn
//**********************************************
void BOOTLOADER_SECTION start_game(void){
	ushort code;

	// R[h`FbNBŏ jmp߂
	code = pgm_read_word(0);
	if ((code & 0xFE0E) != 0x940C){
		return;
	}
//	cli();

//	// 荞݃xN^߂
//	MCUCR = (1<<IVCE);
//	MCUCR = 0;

	// ^C}Q~
	TCCR2A = 0;
//	TCCR2B = 0;
//	TIMSK2 = 0;
//	TIFR2 = (1<<OCF2A);	// 荞݃tONA

	// X[v[hftHg
//	SMCR = 0;

	// SPI[h
	SPCR = 0;
	SPSR = 0;

	// 0ԒnɃWv
	asm volatile("jmp	0\n"::);
}


//**********************************************
//	̃ZN^w
//**********************************************
void BOOTLOADER_SECTION next_sector(struct FILE_DATA *fd){

	fd->sec += 512;
	fd->p += 512;
	if (++(fd->sc) >= SectorsPerCluster){
		fd->cluster = next_cluster(fd->cluster);
		fd->sec = cluster_to_adrs(fd->cluster);
		fd->sc = 0;
	}
}


//*********************************************************
//	NX^ԍf[^i[AhX擾
//*********************************************************
ulong BOOTLOADER_SECTION cluster_to_adrs(uint cluster){

	return (((ulong)cluster - 2) * (ulong)SectorsPerCluster + DataStart) * 512;
}


//*********************************************************
//	̃NX^߂
//*********************************************************
uint BOOTLOADER_SECTION next_cluster(uint c){
	ulong	addr;
	uint	data;
	ulong	fatadr;

	if (FATtype == FAT12){
		// FAT12
		addr = (ulong)FATstart * 512 + (ulong)c + (c >> 1);
		if ((addr & 511) == 511){
			// ZN^܂
			data = read_word(addr) & 0x00FF;
			data |= ((read_word(addr+1) & 0x00FF) << 8);
		} else {
			fatadr = addr & 0xFFFFFE00;
			data = read_word(addr);
		}
		if (c & 1){
			c = data >> 4;
		} else {
			c = data & 0x0fff;
		}
		if (c >= 0x0ff8)	c = 0xFFFF;
	} else {
		// FAT16
		addr = (ulong)FATstart * 512 + (ulong)c * 2;
		fatadr = addr & 0xFFFFFE00;
		c = read_word(addr);
		if (c >= 0xFFF8)	c = 0xFFFF;
	}

	return c;
}


//*******************************************************
//	MMC/SDJ[h 2byteǂ
//	ZN^ẼANZX͂łȂ̂
//	ʍHōl邱
//*******************************************************
uint BOOTLOADER_SECTION  read_word(ulong addr){
	uint	w;
	uint	b;

	b = addr & 511;
	addr &= 0xFFFFFE00;

	mmc_read(addr);

	w = (uint)DiskCache[b++];
	w |= ((uint)DiskCache[b] << 8);

	return w;
}


//*******************************************************
// MMCJ[hPZN^ǂݍ
//*******************************************************
uchar BOOTLOADER_SECTION  mmc_read(ulong addr){
	unsigned int i;
	uchar	r;
	uchar	*buff;

	// fBXNLbVAhXr
//	if (addr == DiskCacheAddr)	return 0;
//	DiskCacheAddr = addr;
	
	MMC_CS_ON;
	r = SPI_command(17, addr);
	if (r == 0){
		for (i = 0; i < 30000; i++){	// ̂҂ꍇ
			r = SPI_in();
			if (r == 0xFE){
				break;		// ]Jn}[N
			}
		}
	}

	if (r != 0xFE){
		r = 1;
		goto QUIT;		// ERROR
	} else {
		r = 0;
	}

	buff = DiskCache;
	for (i = 0; i < 512; i++){
		*buff++ = SPI_in();
	}

	SPI_in();	// CRC
	SPI_in();	// CRC

  QUIT:
	MMC_CS_OFF;
	SPI_in();

	return r;
}


//****************************************
//	MMC/SD SPIR}ho
//****************************************
uchar BOOTLOADER_SECTION  SPI_command(uchar com, ulong arg){
	uint	i;
	uchar	r;

	// BUSY`FbN
	i=0;
	while(1){
		if(SPI_in() == 0xFF)	break;
		if(i++ > 30000)	return 1;	//error
	}

	SPI_out(com|0x40);
	SPI_out(arg >> 24);
	SPI_out(arg >> 16);
	SPI_out(arg >> 8);
	SPI_out(arg);
	SPI_out(0x95);	// R}hCRC

	// R1҂
	for (i = 0; i < 10000; i++){
		r = SPI_in();
		if (r != 0xFF)	break;
	}

	return r;
}


#if SOFTSPI


uchar BOOTLOADER_SECTION  spi_inout(uchar txdata)
{
#define SPILOOPMAX 10

	uchar mask=0x80;
	uchar rxdata=0;
	unsigned char i;

	while(mask){
		if(txdata & mask)
			MMC_PORT |= (1<<MMC_MOSI);	// MOSI =High
		else
			MMC_PORT &= ~(1<<MMC_MOSI);	// MOSI =Low

  		MMC_PORT &= ~(1<<MMC_SCK);    // SCK =Low
		for(i=0;i<SPILOOPMAX;i++){
//			asm volatile("nop\n"::);
		}

		MMC_PORT |= (1<<MMC_SCK);    // SCK =High
		if (MMC_PIN & (1<<MMC_MISO))
			rxdata |= mask;

		for(i=0;i<SPILOOPMAX;i++){
//			asm volatile("nop\n"::);
		}

		mask>>=1;
	}
	MMC_PORT |= (1<<MMC_MOSI);

	return(rxdata);
}

#endif

//****************************************
//	SPIf[^o
//****************************************
void BOOTLOADER_SECTION  SPI_out(uchar data){

	#if SOFTSPI
		spi_inout(data);
	#else
		SPDR = data;
		while(!(SPSR & (1<<SPIF)));
	#endif
}


//****************************************
//	SPIf[^
//****************************************
uchar BOOTLOADER_SECTION  SPI_in(void){

	#if SOFTSPI
		return(spi_inout(0xff));
	#else
		SPDR = 0xFF;
		while(!(SPSR & (1<<SPIF)));
		return SPDR;
	#endif
}


void BOOTLOADER_SECTION  led_drive(void)
{

	// LED\
	unsigned long temp;

	temp = ~ledvram[(int)row];

	//------------------XL
	if(lrflag==0){
		led_sendword(0x0001 << row);	// LED1(ʍ)Am[h_
		led_sendword(0x0000);			// LED2(ʉE)Am[h
		led_sendword(temp >> 16);		// J\[hRed(16bit)
	}else{
		led_sendword(0x0000);			// LED1(ʍ)Am[h
		led_sendword(0x0001 << row);	// LED2(ʉE)Am[h_
		led_sendword(temp & 0xffff);	// J\[hRed(16bit)
	}
	LED_LCHPORT |= (1<<LED_LATCH);
	row++;
	LED_LCHPORT &= ~(1<<LED_LATCH);

	if(row >= LEDHEIGHT){	// 1ʕ`抮
		row=0;
		lrflag ^= 1;
	}

	#ifndef F_CPU
		#define F_CPU    8000000     // CPUNbNg [Hz]
	#endif

	#define PRESCALE   1024      // vXP[l
	#define PRESCALER  7         // vXP[WX^l

    TCCR2A = 0;               // ^C}1 [h 
    TCCR2B = PRESCALER;       // ^C}1 vXP[ݒ

    TCNT2 = 0x100 - ((F_CPU/PRESCALE)/2000);
    TIFR2 |= (1<<TOV2);
    while((TIFR2 & (1<<TOV2))==0);
}

unsigned char BOOTLOADER_SECTION  getkey(void)
{
	unsigned char key;

	// XCb`͑҂
	while(swdata){
		led_drive();
	}	// XCb` OFFɂȂ܂ő҂

	while(1){
		led_drive();
		key = swdata;
		if(key!=0)break;
	}	// XCb` ONɂȂ܂ő҂
	return(key);
}

//*******************************************************
//	C[`
//*******************************************************
int main (void) {
	struct DIRECTORY dir;
//	uchar	buff[10];
	int		fmax;
	int		fn;
	int i;
	unsigned char key;


	//--------led init
	LED_CLKPORT &= ~(1<<LED_CLK);
	LED_LCHPORT &= ~(1<<LED_LATCH);
	LED_CLKDDR |= (1<<LED_CLK);	//output
	LED_DATDDR |= (1<<LED_DATA);	//output
	LED_LCHDDR |= (1<<LED_LATCH);	//output

//	DiskCacheAddr = 0xFFFFFFFF;

	cls();	// ʃNA

//	struct FILE_DATA fd;	//debug
//	spm_main(&fd);			//debug
//	print("E");
	for(i=0; i<32*10; i++){
		led_drive();
	}
//	cls();	// ʃNA


	// Nɂa{^ĂƕKu[gZN^N
	if (swdata != SW_B){
		start_game();	// AvP[VsB܂ĂȂȂ߂
	}

	while(1){
		fmax = 0;
		if (mmc_init() == 0xFF){	// MMC/SDJ[h
			printerr("Card");
			continue;
		}
		i=read_VFAT_info();
		i = read_VFAT_info();
		if(i==1){
			printerr("Fat");//"FAT32?");
		}else if(i==2){
			printerr("Sec");//print("BadSec");
		} else {
			fmax = search_file(&dir, RootDirEntriesCount);
			if (fmax !=0) break;
			printerr("NoFile");		//NoFile
		}
	}

	fn = 1;
	while(1)
	{
		search_file(&dir, fn);
		cls();
		for(i=0;i<8;i++)
			led_putch(dir.filename[i]);

		// XCb`͑҂
		key = getkey();

		// a{^́Aɏݍς݂̃vOu[g(LZ)
		if (key & SW_B){
			start_game();
			// G[Ζ߂Ă
		}

		// `{^͑It@Cu[g
		if (key == SW_A){
			if (check_file(&dir)){
				printerr("File");//print("FileErr.");
			} else {
				// t@Cɖ肪Ȃ̂ŃvO~OJn
				struct FILE_DATA fd;
//				cls();
				open_file(&dir, &fd);
				if (spm_main(&fd) == 0){
					start_game();	// AvP[Vs

					// G[Ζ߂Ă
				}
			}
		}

		// L, R, UP, DN{^Ńt@CI
		if (key & SW_LEFT){
			if (--fn < 1)	fn = fmax;
		} else if (key & SW_RIGHT) {
			if (++fn > fmax)	fn = 1;
//		} else if (key & SW_UP){
//			if (fn > 16)	fn -= 16;
//		} else if (key & SW_DOWN){
//			if ((fn + 16) <= fmax)	fn += 16;
		}
	}
}


//**********************************************
//	t@CI[v
//**********************************************
void BOOTLOADER_SECTION open_file(struct DIRECTORY *dir, struct FILE_DATA *fd){

	fd->size = (ushort)dir->size;
	fd->sc = 0;
	fd->cluster = dir->cluster;
	fd->sec = cluster_to_adrs(fd->cluster);
	fd->p = 0;
}


//*******************************************************
//	ȒPȃt@C`FbN
//*******************************************************
uchar BOOTLOADER_SECTION check_file(struct DIRECTORY *dir){
	ulong	sec;

	if (dir->size > (12L * 1024))	return 1;	// TCY 12KB傫

	// ŏ̃ZN^ǂ
	sec = cluster_to_adrs(dir->cluster);
	if (mmc_read(sec))	return 2;				// ǂݍ݃G[

	// ŏ jmp߂(Flashe 16KBȏ AVȐꍇ jmp߂ɂȂ)
	if (((DiskCache[0] & 0x0E) != 0x0C)||
		((DiskCache[1] & 0xFE) != 0x94)){
		return 3;	// f[^G[
	}

	return 0;
}


//*******************************************************
//	MMC/SDJ[h 32byteǂ buffɊi[
//	DiskCachegƂɒ
//*******************************************************
uchar BOOTLOADER_SECTION read_32(ulong addr, uchar *buff){
	uint	b;
	uchar	i;

	b = addr & 511;
	addr &= 0xFFFFFE00;
	
	if (mmc_read(addr))	return 1;

	for (i = 0; i < 32; i++){
		*buff++ = DiskCache[b++];
	}

	return 0;
}


//*********************************************************
//	MMC/SDJ[h̏
//*********************************************************
uchar mmc_init(void){
	uchar	c;
	long i=100000;

	// |[gB
	MMC_PORT |= (1<<MMC_MOSI)|(1<<MMC_SCK);
	MMC_PORT &= ~(1<<MMC_MISO);		//vAbv֎~
	MMC_DDR &= ~(1<<MMC_MISO);		//input
	MMC_DDR |= (1<<MMC_MOSI)|(1<<MMC_SCK);	//output

	// MMC CSMo͐ݒ
	MMC_CS_PORT |= (1<<MMC_CS);
	MMC_CS_DDR |= (1<<MMC_CS);

	#if SOFTSPI
	#else
		// SPI}X^, CPOL=1, CPHA=1, Clock 8MHz/64=125kHz
		SPCR = (1<<SPE)|(1<<MSTR)|(1<<CPOL)|(1<<CPHA)|(1<<SPR0)|(1<<SPR1);
		SPSR = (1<<SPI2X);
	#endif

	while(i--){
		asm volatile("nop\n"::);
	}

	MMC_CS_OFF;	// CS=H

	// MMC/SD SPI[hڍsÕNbNM
	for (c = 0; c < 20; c++){
		SPI_in();
	}

	// SPI[hڍsR}h
	MMC_CS_ON;	// CS=L
	c = SPI_command(0, 0);
	while ((c != 1)&&(c != 0xFF)){
		c = SPI_command(0, 0);
	}
	while (c == 1){
		c = SPI_command(1, 0);
	}
	MMC_CS_OFF;	// CS=H
	SPI_in();

	#if SOFTSPI
	#else
		// SPI}X^, CPOL=1, CPHA=1, Clock 8MHz/2=4MHz
		SPCR = (1<<SPE)|(1<<MSTR)|(1<<CPOL)|(1<<CPHA);
	#endif
	return c;
}

//*********************************************************
//	VFATǂݎ
//*********************************************************
uchar read_VFAT_info(void){
	uchar	buff[32];
	ulong	sec;
	ushort	bpb;
	ushort	n;

	// VFATǂݎBZN^ 512bytesŌߑłĂ
	read_32(446, buff);								// MBRǂݍ
	bpb = *((ushort *)&buff[8]);					// BPB擪ZN^

	read_32((ulong)bpb * 512, buff);				// ǂݍ
	n = *((ushort *)&buff[11]);						// ZN^
	if (n != 512){
		return 2;	// 1ZN^ 512bytesłȂ
	}

	FATcount = buff[16];		// FAT̐ ʏ 2

	SectorsPerCluster = buff[13];		// NX^̃ZN^
	ReservedSectors = *((ushort *)&buff[14]);	// \ZN^
	FATstart = bpb + ReservedSectors;			// FATJnZN^

	RootDirEntriesCount = *((ushort *)&buff[17]);	// [gfBNgGg

	FATsectors = *((ushort *)&buff[22]);		// FAT̃ZN^
	if (FATsectors == 0){
		return 1;	// FAT32炵
	}

	DIRstart = (ushort)FATstart + (ushort)FATcount * FATsectors;	// FAT̐~ZN^
	n = RootDirEntriesCount / 16;	// [gfBNgɕKvȃZN^
//	if (RootDirEntriesCount % 16){
//		n++;	// Ô߁A]肪o؂グBʏ͕svƎv
//	}
	DataStart = (ulong)DIRstart + (ulong)n;		// f[^i[̈

	sec = (ulong)*((ushort *)&buff[19]);		// ZN^
	if (sec == 0){
		read_32((ulong)bpb * 512 + 32, buff);	// ǂݍ
		sec = *((ulong *)&buff[0]);
	}
	SectorCount = sec;
	sec -= FATstart;
	sec /= SectorsPerCluster;
	if (sec >= 0x1000){
		FATtype = FAT16;	// FAT16
	} else {
		FATtype = FAT12;	// FAT12
	}

	// ǂݍ݂Ȃȉ͕̏sv
	
	// f[^̈ZN^
//	sec = SectorCount - ReservedSectors - FATsectors * FATcount - (ulong)RootDirEntriesCount * 32 / 512;

	// NX^
//	ClusterCount = (ushort)(sec / SectorsPerCluster) + 2;

	return 0;
}


//*********************************************************
//	[gfBNg̃t@CT[`
//	gq BIN ̒ʏt@C
//*********************************************************
int search_file(struct DIRECTORY *dir, int max){
	ulong	adrs;
	int		n, i;

	adrs = (ulong)DIRstart * 512;
	n = 0;
	for (i = 0; i < RootDirEntriesCount; i++){
		read_32(adrs, (uchar *)dir);
		adrs += 32;
		if (dir->filename[0] == 0)	break;
		if ((dir->filename[0] != 0xE5)&&
			(!(dir->att & 0x18))&&
			(dir->ext[0] == 'B')&&
			(dir->ext[1] == 'I')&&
			(dir->ext[2] == 'N')){
			if (++n >= max)	break;
		}
	}
	return n;
}


//*******************************************************
//	ʃNA
//*******************************************************
void BOOTLOADER_SECTION cls(void){
	char i=LEDHEIGHT;

	while(i--){
		ledvram[(int)i] = 0x00000000;
	}
	text_x=0;
//	text_y=0;
}


//*******************************************************
//	܂ʒuɕ\
//*******************************************************
void BOOTLOADER_SECTION print(char *str){

	while(*str){
		led_putch(*str++);
	}
}


//*******************************************************
//	LEDɂP\
//*******************************************************
void BOOTLOADER_SECTION led_putch(unsigned char ch)
{
	char i;
	unsigned char bitdata;
	PGM_P p = (PGM_P)smallfont;
	
	if(ch < 0x20){
		return;
	}

	if (text_x > (32-4)){
//		text_x = 0;
//		text_y += 6;
//		if (text_y > 12){
//			text_y = 0;
			cls();
//		}
	}

	p += ((int)(ch - 0x20) * 3);

	for(i=0 ;i<6 ;i++) {
//		if((ty >= 0)&&(ty <= 15)){
			bitdata = pgm_read_byte(p);
			if((i % 2)==0){
				bitdata >>= 4;
			}else{
				p++;
			}
			bitdata &= 0xf;

			ledvram[(int)i] |= ((unsigned long)bitdata << ((32-4)-text_x));
//		}
	}
	text_x += 4;
}



#define SW_DATPORT  PORTD
#define SW_DATPIN   PIND
#define SW_DATDDR	DDRD
#define SW_DATA		5
#define SW_LCHPORT  PORTC
#define SW_LCHDDR	DDRC
#define SW_LATCH	1

//*******************************************************
//	LEDɂP[h(16bit)]
//*******************************************************
// ʃrbg16bitM
void led_sendword(unsigned int dat)
{
	unsigned int bitmask=0x8000;
	unsigned int swtemp=0;

	SW_LCHDDR  |= (1<<SW_LATCH);
	SW_LCHPORT |= (1<<SW_LATCH);	// SW data b`
//	SW_DATPORT |= (1<<SW_DATA);	//data pullup

	while(bitmask != 0)
	{
		if((SW_DATPIN & (1<<SW_DATA))==0){	//Lowx̏ꍇA
			swtemp |= bitmask;	//rbg1ɃZbg
		}

		if(dat & bitmask)
			LED_DATPORT |=  (1<<LED_DATA);
		else
			LED_DATPORT &= ~(1<<LED_DATA);

		bitmask >>= 1;
		LED_CLKPORT |=  (1<<LED_CLK);
		LED_CLKPORT &= ~(1<<LED_CLK);
	}
	swdata = swtemp>>8;
	SW_LCHPORT &= ~(1<<SW_LATCH);	//SW data b`
}


