//---------------------------------------------------------------------
//(16x16Dot)LED Game for AVR  by Takuya Matsubara / NICO Corp. 2006-2008
// http://www.nicotak.com/avr/
//
//   LED\֐ LED+LED Ή
//
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/sleep.h>
#include "led.h"

#define CAPTURE_SW 0
#if CAPTURE_SW
	#include "sio.h"  // CAPTURE
#endif

unsigned int ledvram[LEDWIDTH*2];	 // LED Bitmap Buffer(VRAM)
char row=0;
char colorflag=0;
char scanflag=0;

#define LED_PORT  PORTB	// LEDp|[g
#define LED_DDR   DDRB	 // LEDp|[go
#define LED_CLK   0		// NbNrbgԍ
#define LED_DATA  2		// f[^rbgԍ
#define LED_LATCH 1		// b`rbgԍ

//void led_sendword(unsigned int dat);
void led_sendword2(unsigned int dat);

//---------------------------------------------------------------------
// LED
// ELEDp|[g܂B
// EVRAM̓e܂B
void led_init(void)
{
	int i;

	LED_DDR |= ((1<<LED_LATCH)|(1<<LED_CLK)|(1<<LED_DATA));	//output
	LED_PORT &= ~(1<<LED_CLK);
	LED_PORT &= ~(1<<LED_LATCH);

	for(i=0;i<LEDWIDTH*2;i++){
		ledvram[i   ] = 0x0000;
	}
}

//---------------------------------------------------------------------
// VRAMAhX擾
// EVRAM𒼐ڏƂɎgp
// ߂lFunsigned int ^|C^BVRAM̐擪AhXB
// @@@@VRAM[1s][2s]...[16s]
//               [1s][1s]...[16s]̏16bit x 32si[Ă܂B
//gpFunsigned int *p = led_getvram();   // VRAMAhX擾
unsigned int * led_getvram(void)
{
	return(ledvram);
}


//---------------------------------------------------------------------
// LED
// EWbNICׂĂLowo͂āALED܂B
// EX[vOɎg܂B
// EVRAM̓e͏܂B
void led_off(void)
{
	led_sendword2(0x0000);
	led_sendword2(0x0000);
	led_sendword2(0x0000);

	LED_PORT |= (1<<LED_LATCH);
	LED_PORT &= ~(1<<LED_LATCH);
}

#if CAPTURE_SW
	unsigned char cap_cnt; //CAPTURE
#endif

//---------------------------------------------------------------------
// LED(48rbgM)
// EVRAMe1s\܂B
// E16+16Ăяo1ʍXVɑ܂B
// EC[v^C}荞݊֐ɒuAJԂĂяoĂB
void led_disp(void)
{
	unsigned int temp;

	return;

	temp = (0x0001 << row);

	led_sendword2(0);	// 
	led_sendword2(0);	// 
	led_sendword2(0);	// 

		//----------------1sPʂ̃XL
//		if(colorflag){
//			led_sendword2(~temp);	// J\[hGreen(_)
//			led_sendword2(ledvram[(int)row+16]);		//Am[h
//			led_sendword2(0xffff);	// J\[hRed()
//		}else{
//			led_sendword2(0xffff);	// 
//			led_sendword2(ledvram[(int)row]);			//Am[h
//			led_sendword2(~temp);	// J\[hRed(_)
//		}

	LED_PORT |= (1<<LED_LATCH);
	LED_PORT &= ~(1<<LED_LATCH);

#if CAPTURE_SW
	if(cap_cnt < LEDWIDTH){			//CAPTURE
		if(cap_cnt==0){
			sio_init();
			sio_tx('A');//CAPTURE
		}
		temp = ledvram[(int)row];	//CAPTURE
		sio_tx(temp & 0xFF);		//CAPTURE
		sio_tx(temp >> 8);			//CAPTURE
		temp = ledvram[(int)row+16];//CAPTURE
		sio_tx(temp & 0xFF);		//CAPTURE
		sio_tx(temp >> 8);			//CAPTURE
	}								//CAPTURE
	cap_cnt++;						//CAPTURE
#endif
	row++;
	if(row >= LEDWIDTH){	// 1ʕ`抮
		row=0;
		colorflag++;
		if(colorflag>=2){
			colorflag=0;
		}
	}
}

//---------------------------------------------------------------------
//sNZ`
//xFXWB0`15
//xFYWB0`15
//colorFJ[R[hB0=A1=ԐFA2=ΐFA3=F
void led_pset(char x,char y,char color)
{
	unsigned int mask;

	if(x<0)return;
	if(y<0)return;
	if(x>15)return;
	if(y>15)return;

	mask=0x8000 >> x;

	ledvram[(int)y   ] &= ~mask;
	ledvram[(int)y+16] &= ~mask;
	if(color & 1) ledvram[(int)y   ] |= mask;
	if(color & 2) ledvram[(int)y+16] |= mask;
}

//--------------------------------------------------------------------------------
//C`
//x1FX1W
//y1FY1W
//x2FX2W
//y2FY2W
//colorFJ[R[hB0=A1=ԐFA2=΁A3=F
void led_line(char x1 ,char y1 ,char x2 ,char y2 ,char color)
{
	char xd;	// X2-X1W̋
	char yd;	// Y2-Y1W̋
	char xs=1;  // X1pixelړ
	char ys=1;  // Y1pixelړ
	char e;

	xd = x2 - x1;	 // X2-X1W̋
	if(xd < 0){
		xd = -xd;	 // X2-X1W̐Βl
		xs = -1;	  // X1pixelړ
	}
	yd = y2 - y1;	 // Y2-Y1W̋
	if(yd < 0){
		yd = -yd;	 // Y2-Y1W̐Βl
		ys = -1;	  // Y1pixelړ
	}
	led_pset (x1, y1 ,color); //hbg`
	e = 0;
	if( yd < xd ) {
		while( x1 != x2) {
			x1 += xs;
			e += (2 * yd);
			if(e >= xd) {
				y1 += ys;
				e -= (2 * xd);
			}
			led_pset (x1, y1 ,color); //hbg`
		}
	}else{
		while( y1 != y2) {
			y1 += ys;
			e += (2 * xd);
			if(e >= yd) {
				x1 += xs;
				e -= (2 * yd);
			}
			led_pset (x1, y1 ,color); //hbg`
		}
	}
}

//--------------------------------------------------------------------------------
// ʃXN[
// EVRAM̒gIɃVtg܂B
// x1: XړʁB+ƍVtg(_E)A-ƉEVtg(_)
// y1: YړʁB+ƏVtg(_)A-ƉVtg(_)
void led_scroll(char x1,char y1)
{
	int i;
	if(x1!=0){
		if(x1>0){
			for(i=0; i<LEDWIDTH*2; i++){
				ledvram[i] <<= x1;
			}
		}else{
			for(i=0; i<LEDWIDTH*2; i++){
				ledvram[i] >>= (-x1);
			}
		}
	}

	if(y1!=0){
		if(y1>0){
			for(i=0; i<LEDWIDTH; i++){
				if((i+y1)>15){
					ledvram[i   ] = 0;
					ledvram[i+16] = 0;
				}else{
					ledvram[i   ] = ledvram[i+y1   ];
					ledvram[i+16] = ledvram[i+y1+16];
				}
			}
		}else{
			for(i=LEDWIDTH-1; i>=0; i--){
				if((i+y1)<0){
					ledvram[i   ] = 0;
					ledvram[i+16] = 0;
				}else{
					ledvram[i   ] = ledvram[i+y1   ];
					ledvram[i+16] = ledvram[i+y1+16];
				}
			}
		}
	}
}


//---------------------------------------------------------------------
// ʃrbg16bitMigpj
//void led_sendword(unsigned int dat)
//{
//	unsigned int bitmask=0x8000;
//
//	while(bitmask != 0)
//	{
//		if(dat & bitmask)
//			LED_PORT |=  (1<<LED_DATA);
//		else
//			LED_PORT &= ~(1<<LED_DATA);
//
//		bitmask >>= 1;
//		LED_PORT |=  (1<<LED_CLK);
//		LED_PORT &= ~(1<<LED_CLK);
//	}
//}

//---------------------------------------------------------------------
// ʃrbg16bitM
void led_sendword2(unsigned int dat)
{
	char bitcnt=16;

	while(bitcnt--)
	{
		if(dat & 1)
			LED_PORT |=  (1<<LED_DATA);
		else
			LED_PORT &= ~(1<<LED_DATA);

		dat >>= 1;
		LED_PORT |=  (1<<LED_CLK);
		LED_PORT &= ~(1<<LED_CLK);
	}
}

