//---------------------------------------------------------------------
//(16x16Dot)LED Game for AVR  by Takuya Matsubara / NICO Corp. 2006-2007
// http://www.nicotak.com/avr/
//
//   BEEP
//---------------------------------------------------------------------
// 
#include <avr/io.h>
#include "beep.h"


#define HZMAX 15750		// TEho͉\ȍōg

//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]


unsigned int beep_temp=0;
unsigned int beep_add=128;
int beep_cnt;

#define BEEP_PORT PORTD
#define BEEP_DDR  DDRD
#define BEEP_BIT  (1<<0)


//--------------------------------------------------------------------------
//TEh@\
// ETEh@\܂B^C}2gp܂B
//߂lFint^BĐ\ȍōgԂ܂BŒg͂̒l1/256łB
unsigned int beep_init(void)
{
	BEEP_DDR |= BEEP_BIT;	//|[go
	return(0);
}


//---------------------------------------------------------------------------
//TEh̋It
//ETEho͂IɎ~߂܂B
void beep_off(void)
{
	BEEP_DDR &= ~BEEP_BIT;	//|[g͂ɐݒio͂𒆎~j
}

//---------------------------------------------------------------------------
//TEho̓JE^̎擾
//߂lFint^B0ȏゾƍĐƂӖłB
unsigned int beep_getcnt(void)
{
	return(beep_cnt);
}

//---------------------------------------------------------------------------
//TEhĐ
// hzFg[Hz]
// timeFĐ[100msP]BƂ10Ȃ1bԍĐ܂B
void beep_set(unsigned int hz,int time)
{
	beep_add = (unsigned char)((unsigned long)hz * 15750L)>> (16-4);

	beep_cnt = time;

//    TCNT2 = beep_sta;        // ^C}2̏lݒ   
//    TIFR2 |= (1 << TOV2);    // I[o[t[tONA
//    TIMSK2 |= (1 << TOIE2);  // ^C}2I[o[t[荞݋
//	BEEP_DDR |= (1<<BEEP_BIT);	//|[go͂ɐݒ
}


void beep_ctrl(void)
{
	beep_temp += beep_add;
//((F_CPU / FREQ_H)/2)
	if(beep_temp >= 0x8000){
		BEEP_PORT ^= BEEP_BIT;	//|[go
	}else{
		BEEP_PORT &= ~BEEP_BIT;	//|[go
	}

	if(beep_cnt){
		beep_add = 0;
		beep_cnt--;
	}
}

