#include "StdAfx.h"
#include "KifData.h"

#include <functional>
#include <sstream>

namespace {

	// HACK: T[o[ɕׂȂ悤ɁA擾邲Ƃɏ҂
	static const DWORD DOWNLOAD_SLEEP_TIME = 50;

	/**
	 * _E[h̃t@CtH[}bg %Y (Nx), %y, %m, %d tɕϊ.
	 * @param[in]   fYear   Nx
	 */
	CString GetFileName(LPCTSTR format, const COleDateTime& date, int fisYear)
	{
		CString fYear, year, month, day;
		fYear.Format(_T("%04d"), fisYear);
		year.Format(_T("%04d"), date.GetYear());
		month.Format(_T("%02d"), date.GetMonth());
		day.Format(_T("%02d"), date.GetDay());

		CString file = format;
		file.Replace(_T("%Y"), fYear);
		file.Replace(_T("%y"), year);
		file.Replace(_T("%m"), month);
		file.Replace(_T("%d"), day);

		return file;
	}

	/**
	 * XR[v𔲂ƂɊ֐s.
	 */
	class CScopeExit
	{
	public:
		CScopeExit(std::function<void()> onExit) : m_onExit(onExit)
		{
		}
		~CScopeExit()
		{
			if (m_onExit) {
				m_onExit();
			}
		}
	private:
		std::function<void()> m_onExit;
	};

	/**
	 * _E[hp HTTP ڑ.
	 */
	class CConnection
	{
	public:
		CConnection() : m_session(_T("NHKKifu")), m_http(NULL)
		{
		}
		~CConnection()
		{
			try {
				if (m_http) {
					m_http->Close();
				}
				m_session.Close();
			}
			catch (CException* e) {
				delete e;
			}
		}

		/**
		 * T[o[ɐڑ.
		 */
		bool Initialize(LPCTSTR serverName)
		{
			try {
				// ̐ڑN[Y
				if (m_http) {
					m_http->Close();
				}

				// T[o[ɐڑ
				m_http = m_session.GetHttpConnection(serverName);
				if (!m_http) {
					m_errmsg = _T("T[o[ɐڑł܂ (GetHttpConnection)");
					return false;
				}
				return true;
			}
			catch (CException* e) {
				delete e;
				return false;
			}
		}

		bool GetFile(LPCTSTR fileName, std::vector<std::string>& lines)
		{
			try {
				lines.clear();

				if (!m_http) {
					m_errmsg = _T("T[o[ɐڑĂ܂");
					return false;
				}

				// HTTP GET NGXg
				CHttpFile* file = m_http->OpenRequest(CHttpConnection::HTTP_VERB_GET, fileName);
				if (!file) {
					m_errmsg = _T("t@C擾ł܂ (OpenRequest)");
					return false;
				}
				CScopeExit se([file]() { file->Close(); });

				// NGXg𑗐M
				if (!file->SendRequest()) {
					m_errmsg = _T("t@C擾ł܂ (SendRequest)");
					return false;
				}

				// ʂ̃Xe[^XR[h擾
				DWORD status = 0;
				if (!file->QueryInfoStatusCode(status)) {
					m_errmsg = _T("t@C擾ł܂ (QueryInfoStatusCode)");
					return false;
				}
				if (status != HTTP_STATUS_OK) {
					m_errmsg.Format(_T("t@C擾ł܂ (%u)"), status);
					return false;
				}

				// ʂ̃f[^擾
				if (!ReadLines(file, lines) || lines.empty() || lines[0].empty()) {
					m_errmsg = _T("t@C擾ł܂ (ReadString)");
					return false;
				}

				return true;
			}
			catch (CException* e) {
				e->Delete();
				return false;
			}
		}

		/**
		 * G[bZ[W擾.
		 */
		const CString& GetErrMsg() const
		{
			return m_errmsg;
		}

	private:
		bool ReadLines(CHttpFile* file, std::vector<std::string>& lines)
		{
			if (!file) {
				return false;
			}

			// ReadString() ́AUNICODE rhł͓oCgPʂ̏ɂȂĂ܂̂ŁAł Read() gpĎŉs

			static const int BUFFSIZE = 4096;
			char buff[BUFFSIZE];

			auto ss = std::stringstream();
			while (UINT size = file->Read(buff, BUFFSIZE)) {
				char* p = buff;
				while (p < buff + size) {
					char c = *p;
					// s܂œǂݍ񂾂Asǉ (s̓XLbv)
					if (c == '\r' || c == '\n') {
						auto line = ss.str();
						// HACK: s̓XLbv (sȂƂO)
						// HACK: Read() ̍Ōオ \r,  Read() ̍ŏ \n ƂȂꍇAempty() ɂȂ\
						// HACK: obt@ߍׂǗ΂悢Ał͂܂ł͂Ȃ
						if (!line.empty()) {
							lines.push_back(std::move(line));
						}

						ss.str("");
						ss.clear(std::stringstream::goodbit);

						// sXLbv
						++p;
						// HACK: Asׂ͂ăXLbv (sȂƂO)
						while (*p == '\r' || *p == '\n') {
							++p;
						}
					}
					// HACK: '\0' ̓XLbv
					else if (c == '\0') {
						++p;
					}
					else {
						ss << c;
						++p;
					}
				}
			}

			return true;
		}

	private:
		/// Socket ڑ
		CInternetSession m_session;
		/// HTTP ڑ
		CHttpConnection* m_http;
		/// G[bZ[W
		CString m_errmsg;
	};

	/**
	 * f[^ϊ.
	 * @param[in]  lines    f[^s
	 * @param[in]  codepage f[^s̃R[hy[W
	 * @param[out] kifData  ϊf[^
	 */
	bool ConvertKif(const std::vector<std::string>& lines, UINT codepage, KifData& kifData)
	{
		tstring from;
		for (const auto& line : lines) {
#ifdef _UNICODE
			// HACK: ̃R[hy[W UNICODE ɕϊ
			from += CA2T(line.c_str(), codepage);
#else
			// HACK: ̃R[hy[W ANSI R[hy[Wɕϊ
			from += CW2T(CA2W(line.c_str(), codepage));
#endif
			from += _T("\n");
		}

		// f[^ϊ
		return ConvertKifData(from.c_str(), from.size(), kifData);
	}

}   // anonymous namespace



CKifData::CKifData() : m_status(S_EMPTY), m_terminate(false)
{
	VERIFY(SUCCEEDED(m_threadPool.Initialize(NULL, 1)));
}

CKifData::~CKifData()
{
	// HACK: Xbh܂Ă璆f
	Terminate();

	m_threadPool.Shutdown();
}

bool CKifData::GetKif(LPCTSTR server, LPCTSTR fileFormat, int year)
{
	// HACK: Xbh܂Ă璆f
	Terminate();

	CSingleLock lock(&m_cs, TRUE);

	m_kifData.clear();

	m_server = server;
	m_fileFormat = fileFormat;
	m_year = year;

	m_terminate = false;
	m_status = S_BUSY;
	m_errmsg.Empty();

	if (!m_threadPool.QueueRequest(this)) {
		m_status = S_FAILED;
		m_errmsg = _T("Wu̎sɎs܂");
		return false;
	}

	return true;
}

CKifData::Status CKifData::GetStatus(CString& errmsg) const
{
	CSingleLock lock(&m_cs, TRUE);

	if (m_status == S_FAILED) {
		errmsg = m_errmsg;
	}
	else {
		errmsg.Empty();
	}

	return m_status;
}

size_t CKifData::GetKifDataSize() const
{
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);
	return m_kifData.size();
}

KifData CKifData::GetKifData(size_t index) const
{
	// HACK: f[^͒PȂ̂ŁAGetKifDataSize()  GetKifData() ̓Ag~bNłȂĂ悢
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);
	return m_kifData[index];
}

CString CKifData::GetDefaultFileName(size_t index) const
{
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);

	const KifData& kifData = m_kifData[index];

	CString str;
	str.Format(_T("%s_%s%s_%s_%s.kif"), kifData.onAir.c_str(), kifData.title.c_str(), kifData.stage.c_str(), kifData.player1.c_str(), kifData.player2.c_str());
	str.Remove(_T('/'));

	// t@CɎgpłȂO
	for (TCHAR c : _T("\\/?:*\"><|")) {
		str.Replace(c, _T('_'));
	}

	return str;
}

bool CKifData::SaveAll(LPCTSTR folder, bool utf8) const
{
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);

	// ׂĐǂ
	bool succeeded = true;
	for (size_t i = 0; i < m_kifData.size(); ++i) {
		// t@C
		TCHAR buf[MAX_PATH];
		_tcscpy(buf, folder);
		::PathAppend(buf, GetDefaultFileName(i));

		// ۑ
		if (!Save(i, buf, utf8)) {
			succeeded = false;
		}
	}

	return succeeded;
}

bool CKifData::Save(size_t index, LPCTSTR filename, bool utf8) const
{
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);

	try {
		CFile file(filename, CFile::modeWrite | CFile::modeCreate);

		// UTF-8
		if (utf8) {
			static const BYTE BOM[3] = { 0xef, 0xbb, 0xbf };
			file.Write(BOM, 3);

#ifdef _UNICODE
			const auto& data = CT2A(m_kifData[index].kif.c_str(), CP_UTF8);
#else
			const auto& data = CW2A(CT2W(m_kifData[index].kif.c_str()), CP_UTF8);
#endif
			file.Write(data.m_psz, strlen(data.m_psz));
		}
		// Shift-JIS
		else {
			const auto& data = CT2A(m_kifData[index].kif.c_str());
			file.Write(data.m_psz, strlen(data.m_psz));
		}

		file.Close();

		return true;
	}
	catch (CException* e) {
		e->Delete();
		return false;
	}
}

bool CKifData::Copy(size_t index) const
{
	CSingleLock lock(&m_cs, TRUE);
	ASSERT(m_status == S_BUSY || m_status == S_SUCCEEDED);

	// Nbv{[hI[v
	if (!::OpenClipboard(NULL)) {
		return false;
	}

	bool succeeded = true;

	// Nbv{[hɂ
	VERIFY(::EmptyClipboard());

	// mۂ
	HGLOBAL hMem = ::GlobalAlloc(GMEM_MOVEABLE, (m_kifData[index].kif.size() + 1) * sizeof(TCHAR));
	if (hMem) {
		// bN
		void* p = ::GlobalLock(hMem);
		if (p) {
			// Ɋf[^Rs[
			_tcscpy((LPTSTR)p, m_kifData[index].kif.c_str());
			::GlobalUnlock(p);
#ifdef _UNICODE
			// Nbv{[hɃ̓e UNICODE eLXgŐݒ肷
			if (!::SetClipboardData(CF_UNICODETEXT, hMem)) {
#else	// #ifdef _UNICODE
			// Nbv{[hɃ̓e ANSI eLXgŐݒ肷
			if (!::SetClipboardData(CF_TEXT, hMem)) {
#endif	// #ifdef _UNICODE
				succeeded = false;
			}
		}
		else {
			succeeded = false;
		}
	}
	else {
		succeeded = false;
	}

	// Nbv{[hN[Y
	VERIFY(::CloseClipboard());

	return succeeded;
}

void CKifData::Terminate()
{
	// Wȕ
	Status status = S_EMPTY;
	{
		CSingleLock lock(&m_cs, TRUE);
		status = m_status;
		// HACK: Wu܂ĂAf
		if (status == S_BUSY) {
			m_terminate = true;
		}
	}
	// HACK: |[Oő҂
	// TODO: Cxg҂
	while (status == S_BUSY) {
		::Sleep(DOWNLOAD_SLEEP_TIME);
		{
			CSingleLock lock(&m_cs, TRUE);
			status = m_status;
		}
	}
}



BOOL CKifData::CDownloadWorker::Initialize(void *pvParam)
{
	return TRUE;
}

void CKifData::CDownloadWorker::Terminate(void* pvParam)
{
}

void CKifData::CDownloadWorker::Execute(RequestType req, void *pvParam, OVERLAPPED* pOverlapped)
{
	CKifData* kifData = (CKifData*)req;
	if (!kifData) {
		return;
	}

	VERIFY(req->m_cs.Lock());

	/// T[o[
	CString server = kifData->m_server;
	/// t@CtH[}bg
	CString fileFormat = kifData->m_fileFormat;
	/// Nx
	int year = kifData->m_year;

	VERIFY(req->m_cs.Unlock());

	// ڑ
	CConnection conn;
	if (!conn.Initialize(server)) {
		CSingleLock lock(&kifData->m_cs, TRUE);
		kifData->m_status = S_FAILED;
		kifData->m_errmsg = conn.GetErrMsg();
		return;
	}

	// 擾ŐV̓ (3/31A邢݈͌ȑO̒߂̓j)
	COleDateTime to = min(COleDateTime::GetCurrentTime(), COleDateTime(year + 1, 3, 31, 12 /* Ôߕsrɗ]T */, 0, 0));
	{
		// (1 = Sunday, 2 = Monday, ..., 7 = Saturday)
		static const int SUNDAY = 1;
		// j
		int dayOfWeek = to.GetDayOfWeek();
		// O̓jɂ
		if (dayOfWeek != SUNDAY) {
			to -= COleDateTimeSpan(dayOfWeek - 1, 0, 0, 0);
		}
	}
	// 擾őO̓ (4/1)
	// HACK: ŐVtɂǂāAŌɕsŔf邽߁AjɂKv͂Ȃ
	COleDateTime from(year, 4, 1, 0, 0, 0);

	// HACK: ŐVtɂǂ
	for (COleDateTime dt = to; dt >= from; ::Sleep(DOWNLOAD_SLEEP_TIME), dt -= COleDateTimeSpan(7, 0, 0, 0)) {
		// ftO`FbN
		{
			CSingleLock lock(&kifData->m_cs, TRUE);
			if (kifData->m_terminate) {
				kifData->m_status = S_TERMINATED;
				return;
			}
		}

		// t@C (f[^) ̓e擾
		std::vector<std::string> lines;
		if (!conn.GetFile(GetFileName(fileFormat, dt, year), lines)) {
			continue;
		}
		if (lines.empty()) {
			continue;
		}

		// UTF-8 BOM mF
		// TODO: ?
		std::string& line = lines[0];
		if (line.size() >= 3 && (unsigned char)line[0] == 0xef && (unsigned char)line[1] == 0xbb && (unsigned char)line[2] == 0xbf) {
			// BOM 폜
			line.erase(0, 3);
		}
		else {
			continue;
		}

		// f[^ϊ
		// HACK: UTF-8 Ōߑł
		// TODO: KifData Rs[A|C^œn
		KifData kd;
		if (!ConvertKif(lines, CP_UTF8, kd)) {
			continue;
		}

		{
			CSingleLock lock(&kifData->m_cs, TRUE);
			kifData->m_kifData.push_back(kd);
		}
	}

	CSingleLock lock(&kifData->m_cs, TRUE);
	kifData->m_status = S_SUCCEEDED;
}

BOOL CKifData::CDownloadWorker::GetWorkerData(DWORD dwParam, void** ppvData)
{
	return FALSE;
}
