#pragma once

#include "NHK_HENKAN.h"
#include <vector>

/**
 * f[^.
 */
class CKifData
{
public:
    CKifData();
    ~CKifData();

    /**
     * NHK t̃T[o[Af[^擾 (񓯊s).
     * @param[in]  server     T[o[ (ex. "cgi2.nhk.or.jp")
     * @param[in]  fileFormat t@CtH[}bg (ex. "goshogi/kifu/score.cgi?d=%y%m%d&t=s")
     *                        %y, %m, %d ́Aꂼ 4 , 2 , 2 ̔N//ɕϊ
     * @param[in]  year       擾Nx (4 ̑j 3 ŏIj(邢͌)܂łΏ)
     */
    bool GetKif(LPCTSTR server, LPCTSTR fileFormat, int year);

    /**
     * Wȕ.
     */
    enum Status {
        S_EMPTY,
        S_BUSY,
        S_SUCCEEDED,
        S_FAILED,
        S_TERMINATED,
    };
    /**
     * WȕԂ擾.
     */
    Status GetStatus(CString& errmsg) const;

    /**
     * 擾f[^擾.
     */
    size_t GetKifDataSize() const;
    /**
     * index Ԗڂ̊f[^擾.
     * HACK: }`Xbhz肵āAQƂł͂ȂRs[ŕԂ.
     */
    KifData GetKifData(size_t index) const;

    /**
     * index Ԗڂ̊̕ۑ́AftHgt@C擾.
     */
    CString GetDefaultFileName(size_t index) const;

    /**
     * ׂĂ̊f[^AwtH_ɕۑ.
     */
    bool SaveAll(LPCTSTR folder, bool utf8) const;
    /**
     * index Ԗڂ̊f[^Awt@Cŕۑ.
     */
    bool Save(size_t index, LPCTSTR filename, bool utf8) const;
    /**
     * index Ԗڂ̊f[^ANbv{[hɃRs[.
     */
    bool Copy(size_t index) const;

private:
	/**
	 * _E[h𒆒f.
	 * (m_cs bNԂŌĂł͂ȂȂ)
	 */
	void Terminate();

private:
    /// f[^ (V̂珇)
    std::vector<KifData> m_kifData;

    // f[^̎擾WuɕKvȃp[^
    /// T[o[
    CString m_server;
    /// t@CtH[}bg
    CString m_fileFormat;
    /// Nx
    int m_year;

    /// f[^̎擾Wȕ
    Status m_status;
    /// f[^̎擾Wu̒ftO
    bool m_terminate;
    /// f[^̎擾sƂ̃G[bZ[W
    CString m_errmsg;

    /**
     * 擾[J[.
     */
    class CDownloadWorker
    {
    public:
        typedef class CKifData* RequestType;
        virtual BOOL Initialize(void *pvParam);
        virtual void Terminate(void* /*pvParam*/);
        void Execute(RequestType req, void *pvParam, OVERLAPPED* pOverlapped) throw();
        virtual BOOL GetWorkerData(DWORD /*dwParam*/, void ** /*ppvData*/);
    };
    /// 擾Xbhv[ (gp)
    CThreadPool<CDownloadWorker> m_threadPool;
    mutable CCriticalSection m_cs;
};
