/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.network;

import com.trolltech.qt.GeneratorUtilities;
import com.trolltech.qt.QFlags;
import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.QNoNativeResourcesException;
import com.trolltech.qt.QNoSuchEnumValueException;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtBlockedEnum;
import com.trolltech.qt.QtBlockedSlot;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.QtJambiGeneratedClass;
import com.trolltech.qt.QtJambiObject;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.internal.QtJambiInternal;
import com.trolltech.qt.network.QAbstractSocket;
import com.trolltech.qt.network.QHostAddress;

@QtJambiGeneratedClass
public class QUdpSocket
extends QAbstractSocket {
    public QUdpSocket() {
        this((QObject)null);
    }

    public QUdpSocket(QObject parent) {
        super((QtJambiObject.QPrivateConstructor)null);
        this.__qt_QUdpSocket_QObject(parent == null ? 0L : parent.nativeId());
        this.proxyAuthenticationRequired.connect(this, "emitProxyAuthenticationRequiredPrivate(QNetworkProxy, QAuthenticator)", Qt.ConnectionType.DirectConnection);
        QSignalEmitter.AbstractSignal sig = (QSignalEmitter.AbstractSignal)GeneratorUtilities.fetchField(this, QAbstractSocket.class, "proxyAuthenticationRequiredPrivate");
        sig.connect(this, "emitProxyAuthenticationRequired(QNetworkProxy,QNativePointer)", Qt.ConnectionType.DirectConnection);
    }

    native void __qt_QUdpSocket_QObject(long var1);

    @QtBlockedSlot
    private final boolean bind_private(QHostAddress address, char port) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_bind_private_QHostAddress_char(this.nativeId(), address == null ? 0L : address.nativeId(), port);
    }

    @QtBlockedSlot
    native boolean __qt_bind_private_QHostAddress_char(long var1, long var3, char var5);

    @QtBlockedSlot
    private final boolean bind_private(QHostAddress address, char port, BindFlag ... mode) {
        return this.bind_private(address, port, new BindMode(mode));
    }

    @QtBlockedSlot
    private final boolean bind_private(QHostAddress address, char port, BindMode mode) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_bind_private_QHostAddress_char_BindMode(this.nativeId(), address == null ? 0L : address.nativeId(), port, mode.value());
    }

    @QtBlockedSlot
    native boolean __qt_bind_private_QHostAddress_char_BindMode(long var1, long var3, char var5, int var6);

    @QtBlockedSlot
    private final boolean bind_private() {
        return this.bind_private('\u0000');
    }

    @QtBlockedSlot
    private final boolean bind_private(char port) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_bind_private_char(this.nativeId(), port);
    }

    @QtBlockedSlot
    native boolean __qt_bind_private_char(long var1, char var3);

    @QtBlockedSlot
    private final boolean bind_private(char port, BindFlag ... mode) {
        return this.bind_private(port, new BindMode(mode));
    }

    @QtBlockedSlot
    private final boolean bind_private(char port, BindMode mode) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_bind_private_char_BindMode(this.nativeId(), port, mode.value());
    }

    @QtBlockedSlot
    native boolean __qt_bind_private_char_BindMode(long var1, char var3, int var4);

    @QtBlockedSlot
    public final boolean hasPendingDatagrams() {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_hasPendingDatagrams(this.nativeId());
    }

    @QtBlockedSlot
    native boolean __qt_hasPendingDatagrams(long var1);

    @QtBlockedSlot
    public final long pendingDatagramSize() {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_pendingDatagramSize(this.nativeId());
    }

    @QtBlockedSlot
    native long __qt_pendingDatagramSize(long var1);

    @QtBlockedSlot
    private final long readDatagram(QNativePointer data, long maxlen, QNativePointer host, QNativePointer port) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_readDatagram_nativepointer_long_nativepointer_nativepointer(this.nativeId(), data, maxlen, host, port);
    }

    @QtBlockedSlot
    native long __qt_readDatagram_nativepointer_long_nativepointer_nativepointer(long var1, QNativePointer var3, long var4, QNativePointer var6, QNativePointer var7);

    @QtBlockedSlot
    private final long writeDatagram(QByteArray datagram, QHostAddress host, char port) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_writeDatagram_QByteArray_QHostAddress_char(this.nativeId(), datagram == null ? 0L : datagram.nativeId(), host == null ? 0L : host.nativeId(), port);
    }

    @QtBlockedSlot
    native long __qt_writeDatagram_QByteArray_QHostAddress_char(long var1, long var3, long var5, char var7);

    @QtBlockedSlot
    private final long writeDatagram(QNativePointer data, long len, QHostAddress host, char port) {
        GeneratorUtilities.threadCheck(this);
        if (this.nativeId() == 0L) {
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " + this.getClass().getName());
        }
        return this.__qt_writeDatagram_nativepointer_long_QHostAddress_char(this.nativeId(), data, len, host == null ? 0L : host.nativeId(), port);
    }

    @QtBlockedSlot
    native long __qt_writeDatagram_nativepointer_long_QHostAddress_char(long var1, QNativePointer var3, long var4, long var6, char var8);

    public static native QUdpSocket fromNativePointer(QNativePointer var0);

    private static native long originalMetaObject();

    protected QUdpSocket(QtJambiObject.QPrivateConstructor p) {
        super(p);
    }

    public final boolean bind(QHostAddress address, int port) {
        return this.bind_private(address, (char)port);
    }

    public final boolean bind() {
        return this.bind_private();
    }

    public final boolean bind(int port) {
        return this.bind_private((char)port);
    }

    public final boolean bind(QHostAddress address, int port, BindFlag ... mode) {
        return this.bind_private(address, (char)port, mode);
    }

    public final boolean bind(QHostAddress address, int port, BindMode mode) {
        return this.bind_private(address, (char)port, mode);
    }

    public final boolean bind(int port, BindFlag ... mode) {
        return this.bind_private((char)port, mode);
    }

    public final boolean bind(int port, BindMode mode) {
        return this.bind_private((char)port, mode);
    }

    public final int readDatagram(byte[] data, HostInfo info) {
        QNativePointer np = new QNativePointer(QNativePointer.Type.Byte, data.length);
        QNativePointer address = info != null && info.address != null ? info.address.nativePointer() : null;
        QNativePointer port = new QNativePointer(QNativePointer.Type.Char);
        int len = (int)this.readDatagram(np, data.length, address, port);
        if (info != null) {
            info.port = port.charValue();
        }
        for (int i = 0; i < len; ++i) {
            data[i] = np.byteAt(i);
        }
        return len;
    }

    public final int readDatagram(byte[] data) {
        return this.readDatagram(data, null);
    }

    public final int writeDatagram(byte[] data, QHostAddress address, int port) {
        QNativePointer np = QtJambiInternal.byteArrayToNativePointer(data);
        return (int)this.writeDatagram(np, data.length, address, (char)port);
    }

    public final int writeDatagram(QByteArray data, QHostAddress address, int port) {
        return (int)this.writeDatagram(data, address, (char)port);
    }

    public static class HostInfo {
        public QHostAddress address = new QHostAddress();
        public int port = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindMode
    extends QFlags<BindFlag> {
        private static final long serialVersionUID = 1L;

        public BindMode(BindFlag ... args) {
            super((QtEnumerator[])args);
        }

        public BindMode(int value) {
            super((QtEnumerator[])new BindFlag[0]);
            this.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @QtBlockedEnum
    public static enum BindFlag implements QtEnumerator
    {
        DefaultForPlatform(0),
        ShareAddress(1),
        DontShareAddress(2),
        ReuseAddressHint(4);

        private final int value;

        private BindFlag(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }

        public static BindMode createQFlags(BindFlag ... values) {
            return new BindMode(values);
        }

        public static BindFlag resolve(int value) {
            return (BindFlag)BindFlag.resolve_internal(value);
        }

        private static Object resolve_internal(int value) {
            switch (value) {
                case 0: {
                    return DefaultForPlatform;
                }
                case 1: {
                    return ShareAddress;
                }
                case 2: {
                    return DontShareAddress;
                }
                case 4: {
                    return ReuseAddressHint;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }
    }
}

