/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.NoteTagsRecord;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.util.ArrayList;
import java.util.List;

public class NoteTagsTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;
    NSqlQuery getNoteTagsQuery;

    public NoteTagsTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table NoteTags...");
        if (!query.exec("Create table NoteTags (noteGuid varchar, tagGuid varchar, primary key(noteGuid, tagGuid))")) {
            this.logger.log(this.logger.HIGH, "Table NoteTags creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("drop table NoteTags");
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getNoteTags(String noteGuid) {
        if (noteGuid == null) {
            return null;
        }
        tags = new ArrayList<String>();
        if (this.getNoteTagsQuery == null) {
            this.prepareGetNoteTagsQuery();
        }
        this.getNoteTagsQuery.bindValue(":guid", noteGuid);
        if (this.getNoteTagsQuery.exec()) ** GOTO lbl13
        this.logger.log(this.logger.EXTREME, "NoteTags SQL select has failed.");
        this.logger.log(this.logger.MEDIUM, this.getNoteTagsQuery.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            tags.add(this.getNoteTagsQuery.valueString(0));
lbl13:
            // 2 sources

            ** while (this.getNoteTagsQuery.next())
        }
lbl14:
        // 1 sources

        return tags;
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getTagNotes(String tagGuid) {
        if (tagGuid == null) {
            return null;
        }
        notes = new ArrayList<String>();
        query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select NoteGuid from NoteTags where tagGuid = :guid");
        query.bindValue(":guid", tagGuid);
        if (query.exec()) ** GOTO lbl14
        this.logger.log(this.logger.EXTREME, "getTagNotes SQL select has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return notes;
lbl-1000:
        // 1 sources

        {
            notes.add(query.valueString(0));
lbl14:
            // 2 sources

            ** while (query.next())
        }
lbl15:
        // 1 sources

        return notes;
    }

    void prepareGetNoteTagsQuery() {
        this.getNoteTagsQuery = new NSqlQuery(this.db.getConnection());
        this.getNoteTagsQuery.prepare("Select TagGuid from NoteTags where noteGuid = :guid");
    }

    /*
     * Unable to fully structure code
     */
    public List<NoteTagsRecord> getAllNoteTags() {
        tags = new ArrayList<NoteTagsRecord>();
        query = new NSqlQuery(this.db.getConnection());
        if (query.exec("Select TagGuid, NoteGuid from NoteTags")) ** GOTO lbl12
        this.logger.log(this.logger.EXTREME, "NoteTags SQL select has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            record = new NoteTagsRecord();
            record.tagGuid = query.valueString(0);
            record.noteGuid = query.valueString(1);
            tags.add(record);
lbl12:
            // 2 sources

            ** while (query.next())
        }
lbl13:
        // 1 sources

        return tags;
    }

    public boolean checkNoteNoteTags(String noteGuid, String tagGuid) {
        if (noteGuid == null || tagGuid == null) {
            return false;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select NoteGuid, TagGuid from NoteTags where noteGuid = :noteGuid and tagGuid = :tagGuid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "checkNoteTags SQL prepare has failed.");
        }
        query.bindValue(":noteGuid", noteGuid);
        query.bindValue(":tagGuid", tagGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "checkNoteTags SQL select has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return false;
        }
        return query.next();
    }

    public void saveNoteTag(String noteGuid, String tagGuid, boolean isDirty) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into NoteTags (noteGuid, tagGuid) Values(:noteGuid, :tagGuid)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL insert prepare has failed.");
        }
        query.bindValue(":noteGuid", noteGuid);
        query.bindValue(":tagGuid", tagGuid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "NoteTags Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        if (!(check = query.prepare("Update Note set isDirty=:isDirty where guid=:guid"))) {
            this.logger.log(this.logger.EXTREME, "RNoteTagsTable.saveNoteTag prepare has failed.");
        }
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":guid", noteGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "RNoteTagsTable.saveNoteTag has failed to set note as dirty.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void deleteNoteTag(String noteGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Delete from NoteTags where noteGuid = :noteGuid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Note SQL delete prepare has failed.");
        }
        query.bindValue(":noteGuid", noteGuid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "NoteTags Table delete failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Pair<String, Integer>> getTagCounts() {
        counts = new ArrayList<Pair<String, Integer>>();
        query = new NSqlQuery(this.db.getConnection());
        if (query.exec("select tagguid, count(noteguid) from notetags group by tagguid;")) ** GOTO lbl12
        this.logger.log(this.logger.EXTREME, "NoteTags SQL getTagCounts has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            newCount = new Pair<String, Integer>();
            newCount.setFirst(query.valueString(0));
            newCount.setSecond(query.valueInteger(1));
            counts.add(newCount);
lbl12:
            // 2 sources

            ** while (query.next())
        }
lbl13:
        // 1 sources

        return counts;
    }
}

