/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.gui.QLineEdit;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.gui.TagLineCompleter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TagLineEdit
extends QLineEdit {
    private String text;
    private final boolean changed;
    public QSignalEmitter.Signal2<List<String>, String> text_changed = new QSignalEmitter.Signal2((QSignalEmitter)this);
    public TagLineCompleter tagCompleter;
    public QSignalEmitter.Signal0 focusLost = new QSignalEmitter.Signal0((QSignalEmitter)this);
    public String currentCompleterSelection;

    public TagLineEdit(List<Tag> allTags) {
        this.textChanged.connect((Object)this, "textChanged(String)");
        this.tagCompleter = new TagLineCompleter(this);
        this.text_changed.connect((Object)this.tagCompleter, "update(List, String)");
        this.tagCompleter.activated.connect((Object)this, "completeText(String)");
        this.tagCompleter.highlightedIndex.connect((Object)this, "completerSelected(QModelIndex)");
        this.changed = false;
        this.currentCompleterSelection = null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    private void textChanged(String t) {
        String[] list;
        this.text = t;
        int cursor_pos = this.cursorPosition();
        String temp_text = this.text.substring(0, cursor_pos);
        int delimeter = temp_text.trim().lastIndexOf(Global.tagDelimeter);
        String prefix = "";
        prefix = delimeter > 0 ? temp_text.substring(delimeter + 1).trim() : temp_text.trim();
        ArrayList newTags = new ArrayList();
        ArrayList<String> currentTags = new ArrayList<String>();
        String[] stringArray = list = this.text.split(Global.tagDelimeter);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            currentTags.add(element.trim());
            ++n2;
        }
        this.text_changed.emit(currentTags, (Object)prefix.trim());
    }

    private void completerSelected(QModelIndex model) {
        this.currentCompleterSelection = null;
        if (model == null) {
            return;
        }
        this.tagCompleter.setCurrentRow(model.row());
        this.currentCompleterSelection = this.tagCompleter.currentCompletion();
        this.tagCompleter.setCurrentRow(model.row());
    }

    public void completeText(String text) {
        int cursor_pos = this.cursorPosition();
        String before_text = this.text().substring(0, cursor_pos);
        String after_text = String.valueOf(this.text().substring(cursor_pos)) + " " + Global.tagDelimeter;
        int prefix_len = before_text.lastIndexOf(Global.tagDelimeter);
        if (prefix_len == -1) {
            prefix_len = cursor_pos;
            before_text = "";
        } else {
            before_text = before_text.substring(0, prefix_len);
        }
        this.setText(this.rebuildTags(String.valueOf(before_text) + Global.tagDelimeter + text + Global.tagDelimeter + after_text));
        this.setCursorPosition(this.text().length());
    }

    public void setTagList(List<Tag> t) {
        this.tagCompleter.resetList();
        this.tagCompleter.setTagList(t);
    }

    public boolean event(QEvent e) {
        if (e.type().equals((Object)QEvent.Type.FocusOut)) {
            this.focusLost.emit();
        }
        return super.event(e);
    }

    private String rebuildTags(String tags) {
        StringBuffer tagBuffer = new StringBuffer(tags.length() * 2);
        StringTokenizer tokens = new StringTokenizer(tags, Global.tagDelimeter);
        boolean first = true;
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            if (!first) {
                tagBuffer.append(String.valueOf(Global.tagDelimeter) + " ");
            }
            first = false;
            tagBuffer.append(token);
        }
        return tagBuffer.toString();
    }
}

