/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellChecker;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class SpellCheck
extends QDialog {
    private boolean replacePressed;
    private boolean cancelPressed;
    private final QLabel currentWord;
    private final QLineEdit replacementWord;
    private String misspelledWord;
    private final QPushButton replace;
    private final QPushButton ignore;
    private final QPushButton ignoreAll;
    private final QPushButton addToDictionary;
    private final QListWidget suggestions;
    private final SpellChecker checker;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public SpellCheck(SpellChecker checker) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "spellCheck.png"));
        this.replacePressed = false;
        this.cancelPressed = false;
        this.checker = checker;
        this.setWindowTitle(this.tr("Spell Check"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout suggestionGrid = new QGridLayout();
        QGridLayout buttonGrid = new QGridLayout();
        this.currentWord = new QLabel(this.misspelledWord);
        this.replacementWord = new QLineEdit();
        this.suggestions = new QListWidget();
        this.replacementWord.textChanged.connect((Object)this, "validateInput()");
        this.suggestions.itemSelectionChanged.connect((Object)this, "replacementChosen()");
        suggestionGrid.addWidget((QWidget)this.currentWord, 1, 1);
        suggestionGrid.addWidget((QWidget)new QLabel(this.tr("Suggestion")), 2, 1);
        suggestionGrid.addWidget((QWidget)this.replacementWord, 3, 1);
        suggestionGrid.addWidget((QWidget)this.suggestions, 4, 1);
        suggestionGrid.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)suggestionGrid, 1, 1);
        this.replace = new QPushButton(this.tr("Replace"));
        this.ignore = new QPushButton(this.tr("Ignore"));
        this.ignoreAll = new QPushButton(this.tr("Ignore All"));
        this.addToDictionary = new QPushButton(this.tr("Add To Dictionary"));
        this.replace.clicked.connect((Object)this, "replaceButtonPressed()");
        this.ignore.clicked.connect((Object)this, "ignoreButtonPressed()");
        this.ignoreAll.clicked.connect((Object)this, "ignoreAllButtonPressed()");
        this.addToDictionary.clicked.connect((Object)this, "addToDictionaryButtonPressed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        suggestionGrid.addWidget((QWidget)this.replace, 1, 2);
        suggestionGrid.addWidget((QWidget)this.ignore, 2, 2);
        suggestionGrid.addWidget((QWidget)this.ignoreAll, 3, 2);
        suggestionGrid.addWidget((QWidget)this.addToDictionary, 4, 2);
        suggestionGrid.setAlignment((QWidget)this.addToDictionary, new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignTop});
        buttonGrid.addWidget((QWidget)new QLabel(), 1, 1);
        buttonGrid.addWidget((QWidget)cancel, 1, 2);
        buttonGrid.addWidget((QWidget)new QLabel(), 1, 3);
        buttonGrid.setColumnStretch(1, 10);
        buttonGrid.setColumnStretch(3, 10);
        grid.addLayout((QLayout)buttonGrid, 2, 1);
    }

    private void replaceButtonPressed() {
        this.replacePressed = true;
        this.cancelPressed = false;
        this.close();
    }

    private void cancelButtonPressed() {
        this.replacePressed = false;
        this.cancelPressed = true;
        this.close();
    }

    private void ignoreButtonPressed() {
        this.replacePressed = false;
        this.cancelPressed = false;
        this.close();
    }

    private void ignoreAllButtonPressed() {
        this.checker.ignoreAll(this.misspelledWord);
        this.close();
    }

    public String getReplacementWord() {
        return this.replacementWord.text();
    }

    public void setWord(String w) {
        this.misspelledWord = w;
        this.currentWord.setText(String.valueOf(this.tr("Word: ")) + this.misspelledWord);
    }

    public boolean replacePressed() {
        return this.replacePressed;
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public void validateInput() {
        this.replace.setEnabled(true);
        this.suggestions.clear();
        if (this.replacementWord.text().trim().equals("")) {
            this.replace.setEnabled(false);
            return;
        }
        List values = this.checker.getSuggestions(this.replacementWord.text(), 10);
        int i = 0;
        while (i < values.size()) {
            this.suggestions.addItem(((Word)values.get(i)).toString());
            ++i;
        }
    }

    private void replacementChosen() {
        String sel = this.suggestions.currentItem().text();
        this.replacementWord.setText(sel);
    }

    private void addToDictionaryButtonPressed() {
        this.checker.addToDictionary(this.misspelledWord);
        this.close();
    }

    public void addSuggestion(String word) {
        this.suggestions.addItem(word);
    }

    public void setCurrentSuggestion(String word) {
        this.replacementWord.setText(word);
    }

    public void clearSuggestions() {
        this.suggestions.clear();
    }

    public void setSelectedSuggestion(int index) {
        if (index < this.suggestions.count()) {
            this.suggestions.setCurrentRow(index);
        }
    }
}

