/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.xml.NoteFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class ThumbnailRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private String guid;
    public NoteSignal noteSignal;
    private boolean keepRunning;
    public boolean interrupt;
    private final DatabaseConnection conn;
    private volatile LinkedBlockingQueue<String> workQueue;
    private static int MAX_QUEUED_WAITING = 1000;
    public QMutex mutex;

    public ThumbnailRunner(String logname, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 300);
        this.noteSignal = new NoteSignal();
        this.guid = null;
        this.keepRunning = true;
        this.mutex = new QMutex();
        this.workQueue = new LinkedBlockingQueue(MAX_QUEUED_WAITING);
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        this.logger.log(this.logger.MEDIUM, "Starting thumbnail thread ");
        while (this.keepRunning) {
            try {
                this.interrupt = false;
                String work = this.workQueue.take();
                if (work.startsWith("GENERATE")) {
                    this.guid = work = work.replace("GENERATE ", "");
                    this.generateThumbnail();
                }
                if (work.startsWith("SCAN") && this.conn.getNoteTable().getThumbnailNeededCount() > 1) {
                    this.scanDatabase();
                }
                if (work.startsWith("IMAGE")) {
                    this.guid = work = work.replace("IMAGE ", "");
                    this.processImage();
                }
                if (!work.startsWith("STOP")) continue;
                this.logger.log(this.logger.MEDIUM, "Stopping thumbail thread");
                this.keepRunning = false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.conn.dbShutdown();
    }

    private void processImage() {
        boolean abort = true;
        if (abort) {
            return;
        }
        this.mutex.lock();
        this.logger.log(this.logger.EXTREME, "Image found " + this.guid);
        this.logger.log(this.logger.EXTREME, "Getting image");
        QPixmap image = new QPixmap();
        if (!image.load(String.valueOf(Global.getFileManager().getResDirPath()) + "thumbnail-" + this.guid + ".png")) {
            this.logger.log(this.logger.EXTREME, "Failure to reload image. Aborting.");
            this.mutex.unlock();
            return;
        }
        this.logger.log(this.logger.EXTREME, "Opening buffer");
        QBuffer buffer = new QBuffer();
        if (!buffer.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
            this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
            this.mutex.unlock();
            return;
        }
        this.logger.log(this.logger.EXTREME, "Filling buffer");
        if (!image.save((QIODevice)buffer, "PNG")) {
            this.logger.log(this.logger.EXTREME, "Failure to write to buffer.  Aborting.");
            this.mutex.unlock();
            return;
        }
        buffer.close();
        this.logger.log(this.logger.EXTREME, "Updating database");
        QByteArray b = new QBuffer((QObject)buffer).buffer();
        this.conn.getNoteTable().setThumbnail(this.guid, b);
        this.conn.getNoteTable().setThumbnailNeeded(this.guid, false);
        this.mutex.unlock();
    }

    private void scanDatabase() {
        this.logger.log(this.logger.HIGH, "Scanning database for notes needing thumbnail");
        if (this.workQueue.size() > 0) {
            return;
        }
        List<String> guids = this.conn.getNoteTable().findThumbnailsNeeded();
        this.logger.log(this.logger.HIGH, String.valueOf(guids.size()) + " records returned");
        int i = 0;
        while (i < guids.size() && this.keepRunning && !this.interrupt) {
            this.guid = guids.get(i);
            this.logger.log(this.logger.HIGH, "Working on:" + guids.get(i));
            this.generateThumbnail();
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Scan completed");
    }

    public synchronized boolean addWork(String request) {
        if (this.workQueue.size() == 0) {
            this.workQueue.offer(request);
            return true;
        }
        return false;
    }

    public synchronized int getWorkQueueSize() {
        return this.workQueue.size();
    }

    private void generateThumbnail() {
        QByteArray js = new QByteArray();
        this.logger.log(this.logger.HIGH, "Starting thumbnail for " + this.guid);
        ArrayList<QTemporaryFile> tempFiles = new ArrayList<QTemporaryFile>();
        Note currentNote = this.conn.getNoteTable().getNote(this.guid, true, true, false, true, false);
        NoteFormatter formatter = new NoteFormatter(this.logger, this.conn, tempFiles);
        currentNote = this.conn.getNoteTable().getNote(this.guid, true, true, false, true, false);
        formatter.setNote(currentNote, true);
        formatter.setHighlight(null);
        js.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        js.append("<style type=\"text/css\">.en-crypt-temp { border-collapse:collapse; border-style:solid; border-color:blue; padding:0.0mm 0.0mm 0.0mm 0.0mm; }</style>");
        js.append("<style type=\"text/css\">en-hilight { background-color: rgb(255,255,0) }</style>");
        js.append("<style> img { max-width:100%; }</style>");
        js.append("<style type=\"text/css\">en-spell { text-decoration: none; border-bottom: dotted 1px #cc0000; }</style>");
        js.append("</head>");
        js.append(formatter.rebuildNoteHTML());
        js.append("</HTML>");
        js.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml.dtd'>", "");
        js.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>", "");
        js.replace("<?xml version='1.0' encoding='UTF-8'?>", "");
        int zoom = 1;
        if (currentNote != null && currentNote.getContent() != null) {
            String content = currentNote.getContent();
            zoom = Global.calculateThumbnailZoom(content);
        }
        this.logger.log(this.logger.HIGH, "Thumbnail file ready");
        this.noteSignal.thumbnailPageReady.emit((Object)this.guid, (Object)js, (Object)zoom);
    }
}

