/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPaintDeviceInterface;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.webkit.QWebPage;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.threads.ThumbnailRunner;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.ListManager;

public class Thumbnailer
extends QObject {
    public QWebPage page = new QWebPage();
    public QImage image;
    public QPainter painter = new QPainter();
    public QMutex mutex = new QMutex();
    public String guid;
    private final QSize size;
    private int zoom = 1;
    private QBuffer buffer;
    private final ApplicationLogger logger;
    private final DatabaseConnection conn;

    public Thumbnailer(ApplicationLogger logger, DatabaseConnection conn, ListManager l, ThumbnailRunner r) {
        this.logger = logger;
        this.page = new QWebPage();
        this.conn = conn;
        this.size = new QSize(1024, 768);
        this.image = new QImage(this.size, QImage.Format.Format_ARGB32_Premultiplied);
        this.page.setViewportSize(this.size);
        this.page.loadFinished.connect((Object)this, "loadFinished(Boolean)");
        this.buffer = new QBuffer();
        this.mutex.unlock();
    }

    public void loadContent(String guid, QByteArray html, int zoom) {
        this.zoom = zoom;
        this.guid = guid;
        this.page.mainFrame().setScrollBarPolicy(Qt.Orientation.Horizontal, Qt.ScrollBarPolicy.ScrollBarAlwaysOff);
        this.page.mainFrame().setScrollBarPolicy(Qt.Orientation.Vertical, Qt.ScrollBarPolicy.ScrollBarAlwaysOff);
        this.page.mainFrame().setContent(html);
    }

    private String loadFinished(Boolean ok) {
        if (!ok.booleanValue()) {
            this.mutex.unlock();
            return null;
        }
        this.logger.log(this.logger.EXTREME, "Creating painter");
        this.painter = new QPainter();
        this.logger.log(this.logger.EXTREME, "Beginning painter");
        this.painter.begin((QPaintDeviceInterface)this.image);
        this.page.mainFrame().setZoomFactor(new Double(this.zoom).doubleValue());
        if (this.painter.paintEngine() == null) {
            this.logger.log(this.logger.EXTREME, "Bad paint engine.  Aborting");
            this.painter.end();
            this.mutex.unlock();
            return null;
        }
        this.logger.log(this.logger.EXTREME, "Rendering image");
        this.page.mainFrame().render(this.painter);
        this.logger.log(this.logger.EXTREME, "Closing painter");
        this.painter.end();
        if (this.image.isNull()) {
            this.logger.log(this.logger.EXTREME, "Error rendering thumbnail image.  Aborting");
            this.mutex.unlock();
            return null;
        }
        this.logger.log(this.logger.EXTREME, "Saving image isNull=" + this.image.isNull() + " Size=" + this.image.size());
        this.logger.log(this.logger.EXTREME, "Adding image to runner");
        this.saveImage();
        this.logger.log(this.logger.EXTREME, "Unlocking thumbnailer");
        this.mutex.unlock();
        return this.guid;
    }

    private void saveImage() {
        this.logger.log(this.logger.EXTREME, "Image found " + this.guid);
        this.logger.log(this.logger.EXTREME, "Opening buffer");
        if (this.buffer == null) {
            this.buffer = new QBuffer();
        }
        if (!this.buffer.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
            this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
            this.mutex.unlock();
            return;
        }
        this.logger.log(this.logger.EXTREME, "Filling buffer");
        QImage img = this.image.scaled(Global.largeThumbnailSize, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
        if (!img.save((QIODevice)this.buffer, "PNG")) {
            this.logger.log(this.logger.EXTREME, "Failure to write to buffer.  Aborting.");
            this.mutex.unlock();
            return;
        }
        this.buffer.close();
        this.logger.log(this.logger.EXTREME, "Updating database");
        QByteArray b = this.buffer.buffer();
        this.conn.getNoteTable().setThumbnail(this.guid, b);
        this.conn.getNoteTable().setThumbnailNeeded(this.guid, false);
    }
}

